/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:19:47 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-backward 8 */

/*
 * This function contains 126 FP additions, 57 FP multiplications,
 * (or, 106 additions, 37 multiplications, 20 fused multiply/add),
 * 31 stack variables, and 64 memory accesses
 */
static const fftw_real K707106781 = FFTW_KONST(+0.707106781186547524400844362104849039284835938);
static const fftw_real K1_414213562 = FFTW_KONST(+1.414213562373095048801688724209698078569671875);
static const fftw_real K2_000000000 = FFTW_KONST(+2.000000000000000000000000000000000000000000000);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_backward_8(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (8 * iostride);
     {
	  fftw_real tmp130;
	  fftw_real tmp137;
	  fftw_real tmp128;
	  fftw_real tmp135;
	  fftw_real tmp134;
	  fftw_real tmp139;
	  fftw_real tmp142;
	  fftw_real tmp147;
	  fftw_real tmp131;
	  fftw_real tmp146;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp129;
	       fftw_real tmp136;
	       fftw_real tmp126;
	       fftw_real tmp127;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp129 = X[2 * iostride];
	       tmp130 = K2_000000000 * tmp129;
	       tmp136 = Y[-2 * iostride];
	       tmp137 = K2_000000000 * tmp136;
	       tmp126 = X[0];
	       tmp127 = X[4 * iostride];
	       tmp128 = tmp126 + tmp127;
	       tmp135 = tmp126 - tmp127;
	       {
		    fftw_real tmp132;
		    fftw_real tmp133;
		    fftw_real tmp140;
		    fftw_real tmp141;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp132 = X[iostride];
		    tmp133 = X[3 * iostride];
		    tmp134 = K2_000000000 * (tmp132 + tmp133);
		    tmp139 = tmp132 - tmp133;
		    tmp140 = Y[-3 * iostride];
		    tmp141 = Y[-iostride];
		    tmp142 = tmp140 + tmp141;
		    tmp147 = K2_000000000 * (tmp141 - tmp140);
	       }
	  }
	  tmp131 = tmp128 + tmp130;
	  X[4 * iostride] = tmp131 - tmp134;
	  X[0] = tmp131 + tmp134;
	  tmp146 = tmp128 - tmp130;
	  X[2 * iostride] = tmp146 - tmp147;
	  X[6 * iostride] = tmp146 + tmp147;
	  {
	       fftw_real tmp138;
	       fftw_real tmp143;
	       fftw_real tmp144;
	       fftw_real tmp145;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp138 = tmp135 - tmp137;
	       tmp143 = K1_414213562 * (tmp139 - tmp142);
	       X[5 * iostride] = tmp138 - tmp143;
	       X[iostride] = tmp138 + tmp143;
	       tmp144 = tmp135 + tmp137;
	       tmp145 = K1_414213562 * (tmp139 + tmp142);
	       X[3 * iostride] = tmp144 - tmp145;
	       X[7 * iostride] = tmp144 + tmp145;
	  }
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 7) {
	  fftw_real tmp52;
	  fftw_real tmp83;
	  fftw_real tmp69;
	  fftw_real tmp79;
	  fftw_real tmp93;
	  fftw_real tmp119;
	  fftw_real tmp105;
	  fftw_real tmp115;
	  fftw_real tmp59;
	  fftw_real tmp80;
	  fftw_real tmp76;
	  fftw_real tmp84;
	  fftw_real tmp96;
	  fftw_real tmp106;
	  fftw_real tmp99;
	  fftw_real tmp107;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp48;
	       fftw_real tmp91;
	       fftw_real tmp65;
	       fftw_real tmp104;
	       fftw_real tmp51;
	       fftw_real tmp103;
	       fftw_real tmp68;
	       fftw_real tmp92;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp46;
		    fftw_real tmp47;
		    fftw_real tmp63;
		    fftw_real tmp64;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp46 = X[0];
		    tmp47 = Y[-4 * iostride];
		    tmp48 = tmp46 + tmp47;
		    tmp91 = tmp46 - tmp47;
		    tmp63 = Y[0];
		    tmp64 = X[4 * iostride];
		    tmp65 = tmp63 - tmp64;
		    tmp104 = tmp63 + tmp64;
	       }
	       {
		    fftw_real tmp49;
		    fftw_real tmp50;
		    fftw_real tmp66;
		    fftw_real tmp67;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp49 = X[2 * iostride];
		    tmp50 = Y[-6 * iostride];
		    tmp51 = tmp49 + tmp50;
		    tmp103 = tmp49 - tmp50;
		    tmp66 = Y[-2 * iostride];
		    tmp67 = X[6 * iostride];
		    tmp68 = tmp66 - tmp67;
		    tmp92 = tmp66 + tmp67;
	       }
	       tmp52 = tmp48 + tmp51;
	       tmp83 = tmp48 - tmp51;
	       tmp69 = tmp65 + tmp68;
	       tmp79 = tmp65 - tmp68;
	       tmp93 = tmp91 - tmp92;
	       tmp119 = tmp91 + tmp92;
	       tmp105 = tmp103 + tmp104;
	       tmp115 = tmp104 - tmp103;
	  }
	  {
	       fftw_real tmp55;
	       fftw_real tmp94;
	       fftw_real tmp72;
	       fftw_real tmp95;
	       fftw_real tmp58;
	       fftw_real tmp97;
	       fftw_real tmp75;
	       fftw_real tmp98;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp53;
		    fftw_real tmp54;
		    fftw_real tmp70;
		    fftw_real tmp71;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp53 = X[iostride];
		    tmp54 = Y[-5 * iostride];
		    tmp55 = tmp53 + tmp54;
		    tmp94 = tmp53 - tmp54;
		    tmp70 = Y[-iostride];
		    tmp71 = X[5 * iostride];
		    tmp72 = tmp70 - tmp71;
		    tmp95 = tmp70 + tmp71;
	       }
	       {
		    fftw_real tmp56;
		    fftw_real tmp57;
		    fftw_real tmp73;
		    fftw_real tmp74;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp56 = Y[-7 * iostride];
		    tmp57 = X[3 * iostride];
		    tmp58 = tmp56 + tmp57;
		    tmp97 = tmp56 - tmp57;
		    tmp73 = Y[-3 * iostride];
		    tmp74 = X[7 * iostride];
		    tmp75 = tmp73 - tmp74;
		    tmp98 = tmp73 + tmp74;
	       }
	       tmp59 = tmp55 + tmp58;
	       tmp80 = tmp55 - tmp58;
	       tmp76 = tmp72 + tmp75;
	       tmp84 = tmp75 - tmp72;
	       tmp96 = tmp94 - tmp95;
	       tmp106 = tmp94 + tmp95;
	       tmp99 = tmp97 - tmp98;
	       tmp107 = tmp97 + tmp98;
	  }
	  X[0] = tmp52 + tmp59;
	  Y[-7 * iostride] = tmp69 + tmp76;
	  {
	       fftw_real tmp61;
	       fftw_real tmp77;
	       fftw_real tmp60;
	       fftw_real tmp62;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp61 = tmp52 - tmp59;
	       tmp77 = tmp69 - tmp76;
	       tmp60 = c_re(W[3]);
	       tmp62 = c_im(W[3]);
	       X[4 * iostride] = (tmp60 * tmp61) + (tmp62 * tmp77);
	       Y[-3 * iostride] = (tmp60 * tmp77) - (tmp62 * tmp61);
	  }
	  {
	       fftw_real tmp87;
	       fftw_real tmp89;
	       fftw_real tmp86;
	       fftw_real tmp88;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp87 = tmp80 + tmp79;
	       tmp89 = tmp83 + tmp84;
	       tmp86 = c_re(W[1]);
	       tmp88 = c_im(W[1]);
	       Y[-5 * iostride] = (tmp86 * tmp87) - (tmp88 * tmp89);
	       X[2 * iostride] = (tmp88 * tmp87) + (tmp86 * tmp89);
	  }
	  {
	       fftw_real tmp81;
	       fftw_real tmp85;
	       fftw_real tmp78;
	       fftw_real tmp82;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp81 = tmp79 - tmp80;
	       tmp85 = tmp83 - tmp84;
	       tmp78 = c_re(W[5]);
	       tmp82 = c_im(W[5]);
	       Y[-iostride] = (tmp78 * tmp81) - (tmp82 * tmp85);
	       X[6 * iostride] = (tmp82 * tmp81) + (tmp78 * tmp85);
	  }
	  {
	       fftw_real tmp117;
	       fftw_real tmp123;
	       fftw_real tmp121;
	       fftw_real tmp125;
	       fftw_real tmp116;
	       fftw_real tmp120;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp116 = K707106781 * (tmp96 - tmp99);
	       tmp117 = tmp115 + tmp116;
	       tmp123 = tmp115 - tmp116;
	       tmp120 = K707106781 * (tmp106 + tmp107);
	       tmp121 = tmp119 - tmp120;
	       tmp125 = tmp119 + tmp120;
	       {
		    fftw_real tmp114;
		    fftw_real tmp118;
		    fftw_real tmp122;
		    fftw_real tmp124;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp114 = c_re(W[2]);
		    tmp118 = c_im(W[2]);
		    Y[-4 * iostride] = (tmp114 * tmp117) - (tmp118 * tmp121);
		    X[3 * iostride] = (tmp118 * tmp117) + (tmp114 * tmp121);
		    tmp122 = c_re(W[6]);
		    tmp124 = c_im(W[6]);
		    Y[0] = (tmp122 * tmp123) - (tmp124 * tmp125);
		    X[7 * iostride] = (tmp124 * tmp123) + (tmp122 * tmp125);
	       }
	  }
	  {
	       fftw_real tmp101;
	       fftw_real tmp111;
	       fftw_real tmp109;
	       fftw_real tmp113;
	       fftw_real tmp100;
	       fftw_real tmp108;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp100 = K707106781 * (tmp96 + tmp99);
	       tmp101 = tmp93 - tmp100;
	       tmp111 = tmp93 + tmp100;
	       tmp108 = K707106781 * (tmp106 - tmp107);
	       tmp109 = tmp105 - tmp108;
	       tmp113 = tmp105 + tmp108;
	       {
		    fftw_real tmp90;
		    fftw_real tmp102;
		    fftw_real tmp110;
		    fftw_real tmp112;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp90 = c_re(W[4]);
		    tmp102 = c_im(W[4]);
		    X[5 * iostride] = (tmp90 * tmp101) + (tmp102 * tmp109);
		    Y[-2 * iostride] = (tmp90 * tmp109) - (tmp102 * tmp101);
		    tmp110 = c_re(W[0]);
		    tmp112 = c_im(W[0]);
		    X[iostride] = (tmp110 * tmp111) + (tmp112 * tmp113);
		    Y[-6 * iostride] = (tmp110 * tmp113) - (tmp112 * tmp111);
	       }
	  }
     }
     if (i == m) {
	  fftw_real tmp3;
	  fftw_real tmp8;
	  fftw_real tmp17;
	  fftw_real tmp37;
	  fftw_real tmp6;
	  fftw_real tmp13;
	  fftw_real tmp11;
	  fftw_real tmp36;
	  fftw_real tmp14;
	  fftw_real tmp22;
	  fftw_real tmp18;
	  fftw_real tmp23;
	  fftw_real tmp40;
	  fftw_real tmp39;
	  fftw_real tmp35;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp1;
	       fftw_real tmp2;
	       fftw_real tmp15;
	       fftw_real tmp16;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp1 = X[0];
	       tmp2 = X[3 * iostride];
	       tmp3 = tmp1 + tmp2;
	       tmp8 = tmp1 - tmp2;
	       tmp15 = Y[0];
	       tmp16 = Y[-3 * iostride];
	       tmp17 = tmp15 + tmp16;
	       tmp37 = tmp16 - tmp15;
	  }
	  {
	       fftw_real tmp4;
	       fftw_real tmp5;
	       fftw_real tmp9;
	       fftw_real tmp10;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp4 = X[2 * iostride];
	       tmp5 = X[iostride];
	       tmp6 = tmp4 + tmp5;
	       tmp13 = tmp5 - tmp4;
	       tmp9 = Y[-2 * iostride];
	       tmp10 = Y[-iostride];
	       tmp11 = tmp9 + tmp10;
	       tmp36 = tmp10 - tmp9;
	  }
	  tmp14 = tmp13 - tmp11;
	  tmp22 = tmp13 + tmp11;
	  tmp18 = tmp8 - tmp17;
	  tmp23 = tmp8 + tmp17;
	  tmp40 = tmp37 - tmp36;
	  tmp39 = tmp3 - tmp6;
	  X[0] = K2_000000000 * (tmp3 + tmp6);
	  {
	       fftw_real tmp41;
	       fftw_real tmp38;
	       fftw_real tmp42;
	       fftw_real tmp44;
	       fftw_real tmp43;
	       fftw_real tmp45;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp41 = tmp39 - tmp40;
	       tmp38 = c_re(W[5]);
	       tmp42 = c_im(W[5]);
	       X[6 * iostride] = (tmp38 * tmp41) + (tmp42 * tmp41);
	       tmp44 = tmp39 + tmp40;
	       tmp43 = c_re(W[1]);
	       tmp45 = c_im(W[1]);
	       X[2 * iostride] = (tmp43 * tmp44) - (tmp45 * tmp44);
	  }
	  tmp35 = c_im(W[3]);
	  X[4 * iostride] = -(tmp35 * (K2_000000000 * (tmp36 + tmp37)));
	  {
	       fftw_real tmp28;
	       fftw_real tmp32;
	       fftw_real tmp29;
	       fftw_real tmp31;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp28 = tmp8 + tmp11;
	       tmp32 = tmp13 + tmp17;
	       tmp29 = K707106781 * (tmp22 + tmp23);
	       tmp31 = K707106781 * (tmp14 - tmp18);
	       {
		    fftw_real tmp27;
		    fftw_real tmp30;
		    fftw_real tmp33;
		    fftw_real tmp34;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp27 = c_re(W[2]);
		    tmp30 = c_im(W[2]);
		    X[3 * iostride] = (tmp27 * (tmp28 - tmp29)) + (tmp30 * (tmp31 + tmp32));
		    tmp33 = c_re(W[6]);
		    tmp34 = c_im(W[6]);
		    X[7 * iostride] = (tmp33 * (tmp28 + tmp29)) + (tmp34 * (tmp32 - tmp31));
	       }
	  }
	  {
	       fftw_real tmp12;
	       fftw_real tmp24;
	       fftw_real tmp19;
	       fftw_real tmp21;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp12 = tmp8 - tmp11;
	       tmp24 = K707106781 * (tmp22 - tmp23);
	       tmp19 = K707106781 * (tmp14 + tmp18);
	       tmp21 = tmp17 - tmp13;
	       {
		    fftw_real tmp7;
		    fftw_real tmp20;
		    fftw_real tmp25;
		    fftw_real tmp26;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp7 = c_re(W[4]);
		    tmp20 = c_im(W[4]);
		    X[5 * iostride] = (tmp7 * (tmp12 - tmp19)) + (tmp20 * (tmp21 - tmp24));
		    tmp25 = c_re(W[0]);
		    tmp26 = c_im(W[0]);
		    X[iostride] = (tmp25 * (tmp12 + tmp19)) + (tmp26 * (tmp21 + tmp24));
	       }
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5, 6, 7};
fftw_codelet_desc fftw_hc2hc_backward_8_desc =
{
     "fftw_hc2hc_backward_8",
     (void (*)()) fftw_hc2hc_backward_8,
     8,
     FFTW_BACKWARD,
     FFTW_HC2HC,
     139,
     7,
     twiddle_order,
};
