/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:19:43 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-backward 6 */

/*
 * This function contains 82 FP additions, 53 FP multiplications,
 * (or, 58 additions, 29 multiplications, 24 fused multiply/add),
 * 25 stack variables, and 48 memory accesses
 */
static const fftw_real K1_500000000 = FFTW_KONST(+1.500000000000000000000000000000000000000000000);
static const fftw_real K500000000 = FFTW_KONST(+0.500000000000000000000000000000000000000000000);
static const fftw_real K866025403 = FFTW_KONST(+0.866025403784438646763723170752936183471402627);
static const fftw_real K2_000000000 = FFTW_KONST(+2.000000000000000000000000000000000000000000000);
static const fftw_real K1_732050807 = FFTW_KONST(+1.732050807568877293527446341505872366942805254);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_backward_6(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (6 * iostride);
     {
	  fftw_real tmp86;
	  fftw_real tmp90;
	  fftw_real tmp95;
	  fftw_real tmp97;
	  fftw_real tmp89;
	  fftw_real tmp91;
	  fftw_real tmp84;
	  fftw_real tmp85;
	  fftw_real tmp96;
	  fftw_real tmp92;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp84 = X[0];
	  tmp85 = X[3 * iostride];
	  tmp86 = tmp84 - tmp85;
	  tmp90 = tmp84 + tmp85;
	  {
	       fftw_real tmp93;
	       fftw_real tmp94;
	       fftw_real tmp87;
	       fftw_real tmp88;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp93 = Y[-2 * iostride];
	       tmp94 = Y[-iostride];
	       tmp95 = K1_732050807 * (tmp93 - tmp94);
	       tmp97 = K1_732050807 * (tmp93 + tmp94);
	       tmp87 = X[2 * iostride];
	       tmp88 = X[iostride];
	       tmp89 = tmp87 - tmp88;
	       tmp91 = tmp87 + tmp88;
	  }
	  X[3 * iostride] = tmp86 + (K2_000000000 * tmp89);
	  tmp96 = tmp86 - tmp89;
	  X[iostride] = tmp96 - tmp97;
	  X[5 * iostride] = tmp96 + tmp97;
	  X[0] = tmp90 + (K2_000000000 * tmp91);
	  tmp92 = tmp90 - tmp91;
	  X[4 * iostride] = tmp92 - tmp95;
	  X[2 * iostride] = tmp92 + tmp95;
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 5) {
	  fftw_real tmp30;
	  fftw_real tmp61;
	  fftw_real tmp40;
	  fftw_real tmp67;
	  fftw_real tmp37;
	  fftw_real tmp50;
	  fftw_real tmp64;
	  fftw_real tmp77;
	  fftw_real tmp47;
	  fftw_real tmp54;
	  fftw_real tmp70;
	  fftw_real tmp74;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp28;
	       fftw_real tmp29;
	       fftw_real tmp38;
	       fftw_real tmp39;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp28 = X[0];
	       tmp29 = Y[-3 * iostride];
	       tmp30 = tmp28 + tmp29;
	       tmp61 = tmp28 - tmp29;
	       tmp38 = Y[0];
	       tmp39 = X[3 * iostride];
	       tmp40 = tmp38 - tmp39;
	       tmp67 = tmp38 + tmp39;
	  }
	  {
	       fftw_real tmp33;
	       fftw_real tmp62;
	       fftw_real tmp36;
	       fftw_real tmp63;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp31;
		    fftw_real tmp32;
		    fftw_real tmp34;
		    fftw_real tmp35;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp31 = X[2 * iostride];
		    tmp32 = Y[-5 * iostride];
		    tmp33 = tmp31 + tmp32;
		    tmp62 = tmp31 - tmp32;
		    tmp34 = Y[-4 * iostride];
		    tmp35 = X[iostride];
		    tmp36 = tmp34 + tmp35;
		    tmp63 = tmp34 - tmp35;
	       }
	       tmp37 = tmp33 + tmp36;
	       tmp50 = K866025403 * (tmp33 - tmp36);
	       tmp64 = tmp62 + tmp63;
	       tmp77 = K866025403 * (tmp62 - tmp63);
	  }
	  {
	       fftw_real tmp43;
	       fftw_real tmp69;
	       fftw_real tmp46;
	       fftw_real tmp68;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp41;
		    fftw_real tmp42;
		    fftw_real tmp44;
		    fftw_real tmp45;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp41 = Y[-2 * iostride];
		    tmp42 = X[5 * iostride];
		    tmp43 = tmp41 - tmp42;
		    tmp69 = tmp41 + tmp42;
		    tmp44 = Y[-iostride];
		    tmp45 = X[4 * iostride];
		    tmp46 = tmp44 - tmp45;
		    tmp68 = tmp44 + tmp45;
	       }
	       tmp47 = tmp43 + tmp46;
	       tmp54 = K866025403 * (tmp46 - tmp43);
	       tmp70 = tmp68 - tmp69;
	       tmp74 = K866025403 * (tmp69 + tmp68);
	  }
	  X[0] = tmp30 + tmp37;
	  {
	       fftw_real tmp51;
	       fftw_real tmp57;
	       fftw_real tmp55;
	       fftw_real tmp59;
	       fftw_real tmp49;
	       fftw_real tmp53;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp49 = tmp40 - (K500000000 * tmp47);
	       tmp51 = tmp49 - tmp50;
	       tmp57 = tmp50 + tmp49;
	       tmp53 = tmp30 - (K500000000 * tmp37);
	       tmp55 = tmp53 - tmp54;
	       tmp59 = tmp53 + tmp54;
	       {
		    fftw_real tmp48;
		    fftw_real tmp52;
		    fftw_real tmp56;
		    fftw_real tmp58;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp48 = c_re(W[1]);
		    tmp52 = c_im(W[1]);
		    Y[-3 * iostride] = (tmp48 * tmp51) - (tmp52 * tmp55);
		    X[2 * iostride] = (tmp52 * tmp51) + (tmp48 * tmp55);
		    tmp56 = c_re(W[3]);
		    tmp58 = c_im(W[3]);
		    Y[-iostride] = (tmp56 * tmp57) - (tmp58 * tmp59);
		    X[4 * iostride] = (tmp58 * tmp57) + (tmp56 * tmp59);
	       }
	  }
	  Y[-5 * iostride] = tmp40 + tmp47;
	  {
	       fftw_real tmp65;
	       fftw_real tmp71;
	       fftw_real tmp60;
	       fftw_real tmp66;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp65 = tmp61 + tmp64;
	       tmp71 = tmp67 - tmp70;
	       tmp60 = c_re(W[2]);
	       tmp66 = c_im(W[2]);
	       X[3 * iostride] = (tmp60 * tmp65) + (tmp66 * tmp71);
	       Y[-2 * iostride] = (tmp60 * tmp71) - (tmp66 * tmp65);
	  }
	  {
	       fftw_real tmp75;
	       fftw_real tmp81;
	       fftw_real tmp79;
	       fftw_real tmp83;
	       fftw_real tmp73;
	       fftw_real tmp78;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp73 = tmp61 - (K500000000 * tmp64);
	       tmp75 = tmp73 - tmp74;
	       tmp81 = tmp73 + tmp74;
	       tmp78 = tmp67 + (K500000000 * tmp70);
	       tmp79 = tmp77 + tmp78;
	       tmp83 = tmp78 - tmp77;
	       {
		    fftw_real tmp72;
		    fftw_real tmp76;
		    fftw_real tmp80;
		    fftw_real tmp82;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp72 = c_re(W[0]);
		    tmp76 = c_im(W[0]);
		    X[iostride] = (tmp72 * tmp75) + (tmp76 * tmp79);
		    Y[-4 * iostride] = (tmp72 * tmp79) - (tmp76 * tmp75);
		    tmp80 = c_re(W[4]);
		    tmp82 = c_im(W[4]);
		    X[5 * iostride] = (tmp80 * tmp81) + (tmp82 * tmp83);
		    Y[0] = (tmp80 * tmp83) - (tmp82 * tmp81);
	       }
	  }
     }
     if (i == m) {
	  fftw_real tmp4;
	  fftw_real tmp18;
	  fftw_real tmp3;
	  fftw_real tmp20;
	  fftw_real tmp9;
	  fftw_real tmp17;
	  fftw_real tmp16;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp4 = X[iostride];
	  tmp18 = Y[-iostride];
	  {
	       fftw_real tmp1;
	       fftw_real tmp2;
	       fftw_real tmp7;
	       fftw_real tmp8;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp1 = X[0];
	       tmp2 = X[2 * iostride];
	       tmp3 = tmp1 + tmp2;
	       tmp20 = tmp1 - tmp2;
	       tmp7 = Y[-2 * iostride];
	       tmp8 = Y[0];
	       tmp9 = tmp7 - tmp8;
	       tmp17 = tmp7 + tmp8;
	  }
	  X[0] = K2_000000000 * (tmp3 + tmp4);
	  {
	       fftw_real tmp10;
	       fftw_real tmp13;
	       fftw_real tmp6;
	       fftw_real tmp12;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp10 = K1_500000000 * tmp9;
	       tmp13 = K866025403 * tmp9;
	       tmp6 = (K866025403 * tmp3) - (K1_732050807 * tmp4);
	       tmp12 = (K500000000 * tmp3) - tmp4;
	       {
		    fftw_real tmp5;
		    fftw_real tmp11;
		    fftw_real tmp14;
		    fftw_real tmp15;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp5 = c_im(W[3]);
		    tmp11 = c_re(W[3]);
		    X[4 * iostride] = (tmp5 * (tmp6 - tmp10)) + (tmp11 * (tmp12 - tmp13));
		    tmp14 = c_re(W[1]);
		    tmp15 = c_im(W[1]);
		    X[2 * iostride] = (tmp14 * (tmp12 + tmp13)) - (tmp15 * (tmp6 + tmp10));
	       }
	  }
	  tmp16 = c_im(W[2]);
	  X[3 * iostride] = tmp16 * (K2_000000000 * (tmp17 - tmp18));
	  {
	       fftw_real tmp21;
	       fftw_real tmp25;
	       fftw_real tmp22;
	       fftw_real tmp24;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp21 = K1_500000000 * tmp20;
	       tmp25 = K866025403 * tmp20;
	       tmp22 = (K866025403 * tmp17) + (K1_732050807 * tmp18);
	       tmp24 = (K500000000 * tmp17) + tmp18;
	       {
		    fftw_real tmp19;
		    fftw_real tmp23;
		    fftw_real tmp26;
		    fftw_real tmp27;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp19 = c_re(W[0]);
		    tmp23 = c_im(W[0]);
		    X[iostride] = (tmp19 * (tmp21 - tmp22)) + (tmp23 * (tmp24 - tmp25));
		    tmp26 = c_re(W[4]);
		    tmp27 = c_im(W[4]);
		    X[5 * iostride] = (tmp26 * (tmp21 + tmp22)) + (tmp27 * (tmp25 + tmp24));
	       }
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5};
fftw_codelet_desc fftw_hc2hc_backward_6_desc =
{
     "fftw_hc2hc_backward_6",
     (void (*)()) fftw_hc2hc_backward_6,
     6,
     FFTW_BACKWARD,
     FFTW_HC2HC,
     107,
     5,
     twiddle_order,
};
