/*! \mainpage
qlibs - C library and headers based on "djb's libs" and libowfat
================================================================

Initially, these libs were excluded from *qmail and forseen to use with eQmail. 
As the packages of djb (D.J. Bernstein) uses these libs in different versions, 
there comes up the need to have a consistent state. 
As time was going on, there was also a need to include additional functionality 
and up-to-date best practices. 
Short - this was the point where some parts from libowfat were included.

The current fehQlibs rather accustom to the needs of different OS.

In theorie - these libs can be used with any djb software.

Achievements
------------

- IPv4/IPv6 unification:

The current package supports unified IPv4/IPv6 socket calls, while IPv6 is the default.

- DNS stub-resolver:

The provided DNS stub-resolver is IPv4 and IPv6 aware.
See the README in the ./dnsstub directory for details.


Installation
------------

Check the INSTALL.md document.


Packaging
---------

The fehQlibs are incompatible with Gentoo's parallel compilation flag '-jN' for N > 1.


Compatibility
-------------

a) Starting with version fehQlibs-15b, GCC 10 and Clang compatibility is provided, 
   which means ISO C conformance.
b) Since fehQlibs-17 strong coupling of application routines previously introduced 
   by the global (external) 'ipv4socket' variable are avoided. 
c) stralloc.h is decoupled from genalloc.h (to be included separately).
   This respects the GCC 10 compilation unit behavior.
d) fehQlibs-25 provide compatibility with GCC 14 and Clang 18. Under the hood, 
   the prototypes include now the correct types of arguments (signatures) required 
   for function pointers. Some warning still exits; some are silly, others need to
   be tackled in forthcoming releases. This depends however on the development 
   of the 'C' standard and the respective 'C' compilers.
e) fehQlibs-28 are C23 (and thus GCC 15.2) compliant.
   _GENERICS for some scan_X and fmt_x routines have been added. See man scan.3/fmt.3.


-----

Updated: 20170329, Kai Peter

Updated: 20200910, Erwin Hoffmann
