#ifndef MSGLINE_H
#define MSGLINE_H

#include <sys/types.h>
#include <stdarg.h> /* required by some curses.h implementations */
#ifdef NEED_NCURSES
#include <ncurses.h>
#else
#include <curses.h>
#endif

#define HISTORY_LEN 16

typedef struct
{
  chtype c;
  char *str;
} MenuChoice;

void showmsg(const char *fmt, ...);
int editline(char *buf, size_t size, const char *prompt, size_t *x, size_t *offx, char *history[HISTORY_LEN]);
int menuline(const char *prompt, const MenuChoice *choice, int curx);
int ok(const char *prompt, int curx);

#endif
