#ifndef BUFFER_H
#define BUFFER_H

#include <regex.h>

#define NUL       ((char)1)
#define FOLDSTART ((char)2)
#define FOLDEND   ((char)4)

#define LEFT      1
#define RIGHT     2

#define BUFMARKS  16

enum Buffermode { CHANGED=1, READONLY=2 };

#define LANGUAGES 14

struct Language
{
  const char *name;     /* name of language          */
  const char *beg;      /* comment begin             */
  const char *end;      /* comment end               */
};

struct Buffer
{
  size_t size;           /* size of buffer area      */
  char *buffer;          /* buffer area with gap     */
  char *gapstart;        /* first character of gap   */
  char *gapend;          /* last character of gap    */
  unsigned int cury;     /* current line number      */
  char *name;            /* name of file             */
  enum Buffermode mode;  /* mode flags               */
  struct Language *lang; /* language                 */
  size_t curch;                /* current character position  */
  unsigned int mark[BUFMARKS]; /* alternate gap start offsets */
  char markused[BUFMARKS];     /* flag for usage of a mark    */
  int msz;                     /* number of marks             */
  int refcnt;                  /* nuber of references         */
};

extern struct Language language[];

struct Buffer *bf_alloc(void);
void bf_free(struct Buffer *b);
int bf_empty(struct Buffer *b);
int bf_forward(struct Buffer *b);
int bf_backward(struct Buffer *b);
int bf_insert(struct Buffer *b, char c, char mark);
int bf_delete(struct Buffer *b);
int bf_lchar(struct Buffer *b, char *c, char *mark);
int bf_rchar(struct Buffer *b, char *c, char *mark);
int bf_load(struct Buffer *b, const char *cmd, const char *filename, int filefd, const char *begin, const char *end);
int bf_save(struct Buffer *b, const char *file, const char *beg, const char *end, unsigned int *chars);
int bf_write(struct Buffer *b, const char *file, unsigned int *chars);
int bf_linestart(struct Buffer *b, int realbegin);
int bf_isfold(struct Buffer *s, int fold, int where);
int bf_lineend(struct Buffer *b, int realend);
int bf_foldstart(struct Buffer *b, int level, unsigned int *linesback);
int bf_foldend(struct Buffer *b, int level, unsigned int *linesforward);
void bf_begin(struct Buffer *b);
void bf_end(struct Buffer *b);
int bf_name(struct Buffer *b, const char *name);
struct Language *bf_lang(struct Buffer *b, struct Language *l);
int bf_gotoline(struct Buffer *b, int line);
int bf_strfsearch(struct Buffer *b, const char *needle, size_t needlesize);
int bf_regfsearch(struct Buffer *b, const regex_t *needle);
int bf_strbsearch(struct Buffer *b, const char *needle, size_t needlesize);
int bf_regbsearch(struct Buffer *b, const regex_t *needle);
void bf_tomark(struct Buffer *b, int to);
int bf_mark(struct Buffer *b, int mark);
void bf_unmark(struct Buffer *b, int mark);

#endif
