/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: vt.h,v 1.3 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef	_vt_h_
#define	_vt_h_

#include "osd.h"
#include "temp.h"
#include "gif.h"
#include "unicode.h"

/* a BDF font character's bounding box */
typedef struct vt_bdf_bbx_s {
	uint8_t w;		/* width */
	uint8_t h;		/* height */
	int8_t a;		/* ascent */
	int8_t d;		/* descent */
}	vt_bdf_bbx_t;

/* a BDF font character's SWIDTH */
typedef struct vt_bdf_swidth_s {
	uint16_t w;
	uint16_t f;
}	vt_bdf_swidth_t;

/* a BDF font character's DWIDTH */
typedef struct vt_bdf_dwidth_s {
	uint16_t w;
	uint16_t f;
}	vt_bdf_dwidth_t;

/* a enumeration of supported font properties */
typedef enum vt_bdf_prop_e {
	PROP_FONTNAME_REGISTRY,
	PROP_FOUNDRY,
	PROP_FAMILY_NAME,
	PROP_WEIGHT_NAME,
	PROP_SLANT,
	PROP_SETWIDTH_NAME,
	PROP_ADD_STYLE_NAME,
	PROP_PIXEL_SIZE,
	PROP_POINT_SIZE,
	PROP_RESOLUTION_X,
	PROP_RESOLUTION_Y,
	PROP_SPACING,
	PROP_AVERAGE_WIDTH,
	PROP_CHARSET_REGISTRY,
	PROP_CHARSET_ENCODING,
	PROP_DEFAULT_CHAR,
	PROP_FONT_ASCENT,
	PROP_FONT_DESCENT,
	PROP_X_HEIGHT,
	PROP_CAP_HEIGHT,
	PROP_UNDERLINE_POSITION,
	PROP_DESTINATION,
	PROP_COPYRIGHT,
	PROP__XBMFED_INFO
}	vt_bdf_prop_t;

/* a BDF font info structure */
typedef struct vt_bdf_info_s {
	char *version;
	char *comment;
	char *font;
	uint32_t size_pixel;
	uint32_t size_res_x;
	uint32_t size_res_y;
	vt_bdf_bbx_t bbx;
	uint32_t prop_count;
	uint32_t prop_mask;
	char *fontname_registry;
	char *foundry;
	char *family_name;
	char *weight_name;
	char *slant;
	char *setwidth_name;
	char *add_style_name;
	uint32_t pixel_size;
	uint32_t point_size;
	uint32_t resolution_x;
	uint32_t resolution_y;
	char *spacing;
	uint32_t average_width;
	char *charset_registry;
	char *charset_encoding;
	uint32_t default_char;
	uint32_t font_ascent;
	uint32_t font_descent;
	uint32_t x_height;
	uint32_t cap_height;
	uint32_t underline_position;
	uint32_t destination;
	char *copyright;
	char *_xmbdfed_info;
	uint32_t chars;
}	vt_bdf_info_t;

/* a BDF font structure */
typedef struct vt_bdf_s {
	int fw;					/* font width */
	int fh;					/* font height */
	int dc;					/* default character */
	vt_bdf_info_t *bi;
	uint32_t *flag;
	vt_bdf_swidth_t *swidth;
	vt_bdf_dwidth_t *dwidth;
	vt_bdf_bbx_t *bbx;
	uint32_t *data;
	int width;
	int height;
	int bytes_per_row;
}	vt_bdf_t;

/* a virtual terminal character attribute */
typedef struct vt_att_s {
	uint16_t code;			/* unicode plane 0 character code */
	uint16_t comb;			/* unicode plane 0 combining code */
	uint8_t fg:4;			/* foreground color */
	uint8_t bg:4;			/* background color */
	uint8_t light:1;		/* highlight flag */
	uint8_t inverse:1;		/* inverse video flag */
	uint8_t underline:1;	/* underline flag */
	uint8_t blink:1;		/* blinking flag */
	uint8_t conceal:1;		/* concealed display */
	uint8_t charset:1;		/* selected character set */
	uint8_t cursor:1;		/* character is drawn with cursor */
	uint8_t setG0:2;		/* G0 character set */
	uint8_t setG1:2;		/* G1 character set */
	uint8_t width:2;		/* width (times BDF font width) */
}	vt_att_t;

/* a virtual terminal cursor state */
typedef struct vt_cur_s {
	int x;
	int y;
	int newx;
	int phase;
	int on;
}	vt_cur_t;

/* a virtual terminal */
typedef struct vt_s {
	gif_t *gif;				/* GIF image associated with this vt */
	char *fontfile;			/* BDF font filename */
	vt_bdf_t bdf;			/* BDF font used to display glyphs */
	int origin_x;			/* x origin of the terminal output range */
	int origin_y;			/* y origin of the terminal output range */
	int width;				/* terminal width */
	int height;				/* terminal height */
	int top;				/* scroll range top line (zero based) */
	int bottom;				/* scroll range bottom line (zero based) */
	gif_color_t pal[16];	/* palette colors */
	vt_att_t **screen;		/* the rows of columns with screen attributes */
	vt_att_t def;			/* default attributes */
	vt_att_t att;			/* current attributes */
	vt_att_t att_saved;		/* saved attributes */
	vt_cur_t cur;			/* current cursor position */
	vt_cur_t cur_saved;		/* saved cursor position */
	int cursor_type;
	int cc_mask;			/* current complement colors mask */
	int cc_save;			/* saved complement colors mask */
	int cnt;				/* count of CSI parameters */
	int par[10];			/* list of CSI parameters */
	uint8_t tabstop[64];	/* tabstop poisitions; marked with 1 bits */
	int state;				/* decoder state */
	int ques;				/* non-zero if question mark in CSI */
	int inverse;			/* inverse video */
	int togmeta;			/* toggle meta character */
	int deccm;				/* DEC cursor mode (0: off, 1: on) */
	int decim;				/* DEC insert mode */
	int decom;				/* DEC origin mode */
	int deccr;				/* DEC send CRLF or LF (0: LF, 1: CRLF) */
	int curkeys;			/* cursor keys */
	int decawm;				/* DEC auto wrap mode */
	int decarm;				/* DEC auto repeat mode */
	int repmouse;			/* report mouse */
	int dspctrl;			/* display control characters */
	int uc;					/* underline color */
	int hc;					/* half-bright color */
	int bell_pitch;			/* bell pitch in Hertz */
	int bell_duration;		/* bell duration in milli seconds */
	int blank_time;			/* console blanking timeout */
	int vesa_time;			/* VESA blanking timeout */
	const uint16_t *trans;	/* unicode translation table */
	int utf_mode;			/* unicode UTF-8 mode (0: off, 1: on) */
	int utf_char;			/* unicode UTF-8 character */
	int utf_count;			/* number of expected UTF-8 codes until char */
}	vt_t;

#ifdef	__cplusplus
extern "C" {
#endif

int vt_bdf_free(vt_t *vt);
int vt_bdf_loadfont(vt_t *vt);
int vt_out(vt_t *vt, int x, int y, vt_att_t *pa);
int vt_zap(vt_t *vt, int x0, int y0, int x1, int y1, int code);
int vt_set_cursor(vt_t *vt, int on);
int vt_set_newx(vt_t *vt, int newx);
int vt_scroll_down(vt_t *vt);
int vt_scroll_up(vt_t *vt);
int vt_ri(vt_t *vt);
int vt_lf(vt_t *vt);
int vt_cr(vt_t *vt);
int vt_gotoxy(vt_t *vt, int x, int y);
int vt_gotoy(vt_t *vt, int y);
int vt_gotoxay(vt_t *vt, int x, int y);
int vt_CSI_lh(vt_t *vt, int on);
int vt_CSI_J(vt_t *vt, int n);
int vt_CSI_K(vt_t *vt, int n);
int vt_CSI_L(vt_t *vt, int n);
int vt_CSI_M(vt_t *vt, int n);
int vt_CSI_AT(vt_t *vt, int n);
int vt_CSI_P(vt_t *vt, int n);
int vt_CSI_X(vt_t *vt, int n);
int vt_CSI_m(vt_t *vt);
int vt_CSI_LINUX(vt_t *vt);
int vt_palette_reset(vt_t *vt);
int vt_reset(vt_t *vt, int width, int height);
int vt_save(vt_t *vt);
int vt_restore(vt_t *vt);
int vt_putch(vt_t *vt, int ch);
int vt_write(vt_t *vt, const char *data, int len);
int vt_printf(vt_t *vt, const char *fmt, ...);
int vt_destroy(vt_t *vt);
vt_t *vt_create(int width, int height);

#ifdef	__cplusplus
}
#endif
#endif	/* !defined(_vt_h_) */
