/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: peermsg.h,v 1.4 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef	_peermsg_h_
#define	_peermsg_h_

#include "osd.h"
#include "crypt.h"
#include "key.h"

#define	MSG_CAN	0x00	/* cancelled message */
#define	MSG_ADV	0x41	/* advertize key */
#define	MSG_REQ	0x42	/* request key */
#define	MSG_ANN	0x43	/* node announcement */
#define	MSG_INS	0x44	/* insert key */
#define	MSG_FPR	0x48	/* fingerprint announcement */
#define	MSG_FEC	0x50	/* request FEC reconstruction of chunks */
#define	MSG_BCM	0x60	/* broadcast message (chat etc.) */

#define	MSG_HTL(m)		((m)->htl)

/* a peer message */
typedef struct peer_msg_s {
	uint8_t cmd;			/* message command (MSG_... defines) */
	uint8_t htl;			/* hops to live */
	sha1_digest_t sha1;		/* the key of this message */
	size_t size;			/* size of the attached data packet */
	uint8_t data[1];		/* 1 and some more data bytes */
}	peer_msg_t;

#ifdef	__cplusplus
extern "C" {
#endif

int msg2stream(void *buff, peer_msg_t *msg, size_t *psize);
int stream2msg(peer_msg_t *msg, void *buff, size_t size);

#ifdef	__cplusplus
}
#endif
#endif	/* !defined(_peermsg_h_) */
