#ifndef __KEYMAP_H__
#define __KEYMAP_H__ 1
/* 
   elmo - ELectronic Mail Opertor

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "exec.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/

struct _key {
        int     key;
        exec_t *exec;
};


typedef struct keymap {
        struct _key *keys;
        struct _key *meta;
        int          k_size;
        int          k_count;
        int          m_size;
        int          m_count;
} keymap_t;

/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/

keymap_t keymap_default;

/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void         keymap_init (keymap_t *km);
extern void         keymap_destroy (keymap_t *km);
extern struct _key *keymap_lookup (keymap_t *km, int key, int no_default);
extern struct _key *keymap_lookup_fun (keymap_t *km, void (*)(void));
extern void         keymap_add (keymap_t *km, int key, int meta, void (*)(void));
extern void         keymap_add_exec (keymap_t *km, int key, int meta, exec_t *exec);
extern int          keymap_action (keymap_t *km, int key, int meta);
extern void         keymap_disable_default (void);
extern void         keymap_enable_default (void);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER keymap.h
 *
 ****************************************************************************/
#endif
