/***************************************************************************
                          tag.h  -  description
                             -------------------
    begin                : Sat May 11 2002
    copyright            : (C) 2002-2003 by Tim-Philipp Mller
    email                : t.i.m at orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ed2k_gui_tag_h_included_
#define _ed2k_gui_tag_h_included_

#include "ramfile.h"

struct NGS_tag
{
	guint8      type;   /* the tag type (hash, string, int, float, etc.) */
	gchar      *name;   /* tag name                                      */
	gpointer    data;   /* tag data (guint, gchar*, etc.)                */
} ;

typedef struct NGS_tag NGS_tag;

enum
{
	TAGTYPE_UNDEFINED = 0x00,
	TAGTYPE_HASH = 0x01,
	TAGTYPE_STRING = 0x02,
	TAGTYPE_INT = 0x03,
	TAGTYPE_FLOAT = 0x04,
	TAGTYPE_BOOL,
	TAGTYPE_BOOLARRAY,
	TAGTYPE_BLOB,
	TAGTYPE_LAST_UNDEFINED
} ;

/* tag name abbreviations */

#define TAGNAME_FILENAME_SHORT          "\x01\x00"
#define TAGNAME_FILESIZE_SHORT          "\x02\x00"
#define TAGNAME_FILETYPE_SHORT          "\x03\x00"
#define TAGNAME_FILEFORMAT_SHORT        "\x04\x00"
#define TAGNAME_TRANSFERED_SHORT        "\x08\x00"
#define TAGNAME_SERVERDESCRIPTION_SHORT "\x0b\x00"
#define TAGNAME_CLIENTVERSION_SHORT     "\x11\x00"
#define TAGNAME_TEMPFILENAME_SHORT      "\x12\x00"
#define TAGNAME_PRIORITY_SHORT          "\x13\x00"
#define TAGNAME_GAPSTART_SHORT          "\x09\x00"
#define TAGNAME_GAPEND_SHORT            "\x0a\x00"
#define TAGNAME_AVAILABILITY_SHORT      "\x15\x00"
#define TAGNAME_PING_SHORT              "\x0c\x00"
#define TAGNAME_PREFERENCE_SHORT        "\x0e\x00"
#define TAGNAME_PORT_SHORT              "\x0f\x00"

/* functions */

NGS_tag     *tag_new (guint8 type, const gchar *name);
/*NGS_tag     *tag_new_hash (const gchar *name, const guint8 *hash); */
NGS_tag     *tag_new_integer (const gchar *name, gint32 val);
NGS_tag     *tag_new_string (const gchar *name, const gchar *stringval);
NGS_tag     *tag_new_float (const gchar *name, gfloat fval);
NGS_tag     *tag_new_from_ramfile (ramfile *rf);

void         taglist_write_to_ramfile (GPtrArray *taglist, ramfile *rf);
GPtrArray   *taglist_read_from_ramfile (ramfile *rf);
void         taglist_dump (GPtrArray *taglist, const gchar *msg);
void         taglist_free (GPtrArray *taglist);
NGS_tag     *taglist_find_tag_from_tagname (GPtrArray *taglist, const gchar *tagname);



void
tag_addedit_string_tag ( GPtrArray *taglist,
                         const gchar *name,
                         const gchar *newvalue,
                         gboolean mustexist,
                         gboolean mustnotexist);

void
tag_addedit_integer_tag ( GPtrArray *taglist,
                          const gchar *name,
                          guint32 newvalue,
                          gboolean mustexist,
                          gboolean mustnotexist);

void
tag_addedit_float_tag  ( GPtrArray *taglist,
                         const gchar *name,
                         gfloat newvalue,
                         gboolean mustexist,
                         gboolean mustnotexist);

gboolean
taglist_get_int_tag ( GPtrArray *taglist,
                      const gchar *tagname,
                      guint *value );

gboolean
taglist_get_string_tag ( GPtrArray *taglist,
                         const gchar *tagname,
                         const gchar **value );

#endif


