/***************************************************************************
               servers.h  -  gtk+-2.x version of the servers list
               --------------------------------------------------
    begin                : Sat Feb 15 2003
    copyright            : (C) 2003 by Axel C, Tim-Philipp Mller
    email                : axel@banzais.org, t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ED2K_GUI_SERVERS_H_INCLUDED_
#define _ED2K_GUI_SERVERS_H_INCLUDED_

#include "global.h"
#include "statusbar.h"
#include <time.h>


/* if we haven't gotten anything after 30secs, we probably never will */
#define SERVER_WO_STATS_DEAD_SECONDS 30




typedef enum
{
 SERVERS_CONNECT_STATUS_CONNECTING = 0,
 SERVERS_CONNECT_STATUS_PLACEDONQ,
 SERVERS_CONNECT_STATUS_CANTCONNECT,            // ie. an undesired disconnect
 SERVERS_CONNECT_STATUS_DISCONNECTED,           // ie. a 'normal' disconnected
 SERVERS_CONNECT_STATUS_PLACEDONQ_DEADLOCK,     // oops, deadlocked ?!
 SERVERS_CONNECT_STATUS_DO_SERVER_ROTATE,
 SERVERS_CONNECT_STATUS_THINKS_WE_ARE_FIREWALLED,
 SERVERS_CONNECT_STATUS_GOT_BLACKLISTED,
 SERVERS_CONNECT_STATUS_INVALID,
} ServersConnectStatus;



typedef enum
{
	SERVER_LIST_PRIMARY = 0,
	SERVER_LIST_SECONDARY,
	SERVER_LIST_NUM,
} ServerListNum;


typedef enum
{
 SERVER_PRIO_LOW=0,
 SERVER_PRIO_NORMAL=1,
 SERVER_PRIO_HIGH=2
} ServerPriority;



guint         servers_get_count (void);

GtkWidget    *servers_page_create (void);

void          servers_connect_queue_clear (void);

void          servers_remove_dead (void);

void          servers_cleanup (void); /* needed by http_get.c */

void          servers_toolbar_icon_popup_menu (guint button, guint32 activate_time);

void          servers_fetch_serverlist (ServerListNum num);

void          servers_reinstate_alwaysconnected_option (void);

gboolean	    servers_lookup (guint32 ip, guint16 port);

void          servers_add_or_update_record (guint32 ip, guint16 port, const gchar *name, const gchar *desc, guint32 users, guint32 files, guint32 ping, gint8 pref);

void          servers_show_dead_alive_stats (void);



#endif


