/***************************************************************************
                          search.h  -  description
                             -------------------
    begin                : Tue Feb 25 2003
    copyright            : (C) 2003 by Tim-Philipp Mller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ed2k_gui_search_h_included_
#define _ed2k_gui_search_h_included_

#include <gtk/gtkliststore.h>
#include <gtk/gtksizegroup.h>
#include <gtk/gtkwidget.h>

enum
{
 SEARCH_NUM_COL = 0,
 SEARCH_SIZE_COL,
 SEARCH_FLAGS_COL,
 SEARCH_AVAILABILITY_COL,
 SEARCH_BITRATE_COL,
 SEARCH_LENGTH_MINUTES_COL,

 SEARCH_NAME_COL,
 SEARCH_ARTIST_COL,
 SEARCH_ALBUM_COL,
 SEARCH_TITLE_COL,
 SEARCH_LENGTH_COL,
 SEARCH_CODEC_COL,
 SEARCH_TYPE_COL,
 SEARCH_FORMAT_COL,

 SEARCH_HASH_COL,
 SEARCH_ALTNAMES_COL,

 SEARCH_ICON_COL,

 SEARCH_WEIGHT,
 SEARCH_WEIGHT_SET,

 SEARCH_FOREGROUND_GDK,
 SEARCH_FOREGROUND_SET,

 SEARCH_SIZE_STRING_COL,
 SEARCH_HASH_STRING_COL,

 SEARCH_N_COLUMNS
} ;

#define SEARCH_COLUMN_TYPES\
\
 G_TYPE_UINT,   /* the donkey core internally is limited to a size value of 32 bit */ \
 G_TYPE_UINT,\
 G_TYPE_UINT,\
 G_TYPE_UINT,\
 G_TYPE_UINT,\
 G_TYPE_UINT,\
\
 G_TYPE_STRING,\
 G_TYPE_STRING,\
 G_TYPE_STRING,\
 G_TYPE_STRING,\
 G_TYPE_STRING,\
 G_TYPE_STRING,\
 G_TYPE_STRING,\
 G_TYPE_STRING,\
\
 G_TYPE_POINTER,\
 G_TYPE_POINTER,\
\
 GDK_TYPE_PIXBUF,\
\
 G_TYPE_INT,\
 G_TYPE_BOOLEAN,\
\
 GDK_TYPE_COLOR,\
 G_TYPE_BOOLEAN,\
 G_TYPE_STRING,\
 G_TYPE_STRING\


#define SEARCH_FLAG_ALREADY_HAVE_THIS    ( 1 << 1 )
#define SEARCH_FLAG_BLACKLISTED          ( 1 << 2 )
#define SEARCH_FLAG_HIGH_AVAILABILITY    ( 1 << 3 )

#define SEARCH_HIGH_AVAILABILITY         20

#define SEARCH_MAX_TAB_TEXT_LEN          25

#define LINK_SEARCHLIST_LABEL            _("ed2k-links")

struct _Search
{
	GtkWidget      *frame;
	GtkWidget      *view;

	GtkListStore   *store;

	gchar          *phrase_utf8;

	gboolean        hasArtist;
	gboolean        hasAlbum;
	gboolean        hasTitle;
	gboolean        hasLength;
	gboolean        hasCodec;
	gboolean        hasBitrate;
	gboolean        hasAvailability;
	gboolean        isUserList;

	guint           filtered;        /* no. of results filtered out */
} ;

typedef struct _Search Search;


/* functions */

void                search_from_toolbar (const gchar *searchphrase_utf8);

void                search_remove_all (Search *search, guint flag);

GtkWidget          *search_create_page (void);

void                search_delete (Search *search);

Search             *search_get_current_search (void);

void                search_update_filename_weight_set (void);

void                search_add_or_update_record ( Search *search,
                                                  const guint8 *hash,
                                                  const guint8 *servicehash,
                                                  guint32 size,
                                                  guint32 availability,
                                                  const gchar *name,
                                                  const gchar *type,
                                                  const gchar *format,
                                                  const gchar *mp3_artist,
                                                  const gchar *mp3_album,
                                                  const gchar *mp3_title,
                                                  const gchar *length,
                                                  guint32 bitrate,
                                                  const gchar *codec);


Search              *search_get_ed2k_link_search (void);

void                 search_switch_to_search_page (Search *search);

GtkWidget           *search_create_options_hbox ( GtkSizeGroup *sizegroup_go_about,
                                                  GtkSizeGroup *sizegroup_logos,
                                                  GSList **list_entrywidgets,
                                                  GSList **list_labelwidgets);

void                 search_set_overnet_mode (gboolean overnet);

void                 search_onShowSearchOptionsToggled ( GtkWidget *widget,
                                                         gpointer data);

void                 search_onEntryWidgetChanged ( GtkWidget *widget,
                                                   gpointer data);

#endif


