/*
 *   misc.h
 *
 *
 *   (c) 2001 Tim-Philipp Muller <t.i.m@orange.net>
 *
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ED2K_GUI_MISC_H_INCLUDED_
#define _ED2K_GUI_MISC_H_INCLUDED_

#include "global.h"
#include "icons.h"

#include <sys/types.h>	// for pid_t

#define FILETYPE_AUDIO       _("Audio")
#define FILETYPE_VIDEO       _("Video")
#define FILETYPE_PROGRAM     _("Program")
#define FILETYPE_DOCUMENT    _("Document")
#define FILETYPE_IMAGE       _("Image")
#define FILETYPE_ARCHIVE     _("Archive")
#define FILETYPE_SUBTITLES   _("Subtitles")
#define FILETYPE_CDIMAGE     _("CD Image")


#define misc_gnet_http_url_okay(gurl)	(!((!gurl)||(!gurl->scheme)||(g_ascii_strncasecmp(gurl->scheme,"http",4)!=0)||(!gurl->hostname)||(!gurl->path)))


const gchar   *hash_to_hash_str (const guint8 *hash);

const guint8  *hash_str_to_hash (const gchar hash_str[]);

const gchar   *human_size (guint bytes);

void           invoke_browser_with_url (const gchar *url);

const gchar   *seconds_into_human_time (guint seconds);

void           exec_command_on_complete_download (const gchar *filename);

void           remove_junk_chunk (gchar *str, gchar *from, gchar *to);

void           remove_junk_from_filename (gchar *str);

gchar         *choplast (gchar *str);	// chops off last character of a string, returns ptr to string

gint           spawn_file_preview (const gchar *filename, const gchar *extension);

gchar        **misc_get_array_of_lines_from_textfile ( const gchar *filename,
                                                       gboolean     err_if_not_exist,
                                                       gboolean     err_if_empty );

const gchar   *misc_get_extension_from_filename (const gchar *name);
const gchar   *misc_get_filetype_from_extension (const gchar *ext);

gint           misc_get_ncpus (void);

gboolean       misc_ip_is_local (guint32 ip);

gboolean       misc_check_if_ed2klink_is_valid (const gchar *ed2klink_utf8,
                                                gchar      **fn,
                                                guint       *fnsize,
                                                gchar      **hashstring,
                                                gboolean    *addpaused,
                                                guint       *addpriority);

void             misc_boot_overnet (void);
void             misc_boot_overnet_queue_boot_string (gchar *command);
void             misc_boot_overnet_stop_booting (void);

const gchar     *misc_get_prio_string (guint prio);

const gchar     *misc_get_human_size_utf8 (gchar *buf, guint buflen, guint size);

guint            misc_hash_hash (gconstpointer key);

gboolean         misc_hash_equal (gconstpointer key1, gconstpointer key2);

void             misc_hashtable_destroy (GHashTable **p_ht);

gchar           *misc_remove_junk_from_servername (const gchar *name);


#endif


