/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.synchronize.GlobalRefreshResourceSelectionPage;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;

public abstract class SubscriberParticipantWizard
extends Wizard {
    private GlobalRefreshResourceSelectionPage selectionPage;
    private IWizard importWizard;

    public SubscriberParticipantWizard() {
        this.setDefaultPageImageDescriptor(TeamImages.getImageDescriptor("wizban/share_wizban.gif"));
        this.setNeedsProgressMonitor(false);
    }

    public String getWindowTitle() {
        return Policy.bind("GlobalRefreshSubscriberPage.0");
    }

    public void addPages() {
        if (this.getRootResources().length == 0) {
            this.importWizard = this.getImportWizard();
            this.importWizard.setContainer(this.getContainer());
            this.importWizard.addPages();
            IWizardPage startingPage = this.importWizard.getStartingPage();
            if (startingPage != null) {
                startingPage.setTitle(Policy.bind("SubscriberParticipantWizard.0", this.getName()));
                startingPage.setDescription(Policy.bind("SubscriberParticipantWizard.1", this.importWizard.getWindowTitle()));
            }
        } else {
            this.selectionPage = new GlobalRefreshResourceSelectionPage(this.getRootResources());
            this.selectionPage.setTitle(Policy.bind("GlobalRefreshSubscriberPage.1", this.getName()));
            this.selectionPage.setMessage(Policy.bind("GlobalRefreshSubscriberPage.2"));
            this.addPage((IWizardPage)this.selectionPage);
        }
    }

    public boolean performFinish() {
        if (this.importWizard != null) {
            return this.importWizard.performFinish();
        }
        IResource[] resources = this.selectionPage.getRootResources();
        if (resources != null && resources.length > 0) {
            SubscriberParticipant participant = this.createParticipant(this.selectionPage.getSynchronizeScope());
            TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
            participant.run(null);
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.importWizard != null) {
            return this.importWizard.getNextPage(page);
        }
        return super.getNextPage(page);
    }

    public boolean performCancel() {
        if (this.importWizard != null) {
            return this.importWizard.performCancel();
        }
        return super.performCancel();
    }

    public boolean canFinish() {
        if (this.importWizard != null) {
            return this.importWizard.canFinish();
        }
        return super.canFinish();
    }

    public IWizardPage getStartingPage() {
        if (this.importWizard != null) {
            return this.importWizard.getStartingPage();
        }
        return super.getStartingPage();
    }

    protected abstract IResource[] getRootResources();

    protected abstract SubscriberParticipant createParticipant(ISynchronizeScope var1);

    protected abstract String getName();

    protected abstract IWizard getImportWizard();
}

