/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.update.core.SiteManager;

public abstract class AbstractScriptGenerator
implements IXMLConstants,
IPDEBuildConstants,
IBuildPropertiesConstants {
    protected static String outputFormat = "zip";
    protected static boolean embeddedSource = false;
    protected static boolean forceUpdateJarFormat = false;
    private static List configInfos;
    protected static String workingDirectory;
    protected static boolean buildingOSGi;
    protected AntScript script;

    public static List getConfigInfos() {
        return configInfos;
    }

    public abstract void generate() throws CoreException;

    public String getPropertyFormat(String propertyName) {
        StringBuffer sb = new StringBuffer();
        sb.append("${");
        sb.append(propertyName);
        sb.append("}");
        return sb.toString();
    }

    public static void setConfigInfo(String spec) throws CoreException {
        configInfos.clear();
        String[] configs = Utils.getArrayFromStringWithBlank(spec, "&");
        configInfos = new ArrayList(configs.length);
        String[] os = new String[configs.length];
        String[] ws = new String[configs.length];
        String[] archs = new String[configs.length];
        for (int i = 0; i < configs.length; ++i) {
            String[] configElements = Utils.getArrayFromStringWithBlank(configs[i], ",");
            if (configElements.length != 3) {
                Status error = new Status(4, "org.eclipse.pde.build", 22, Policy.bind("error.configWrongFormat", configs[i]), null);
                throw new CoreException((IStatus)error);
            }
            Config aConfig = new Config(configs[i]);
            if (aConfig.equals(Config.genericConfig())) {
                configInfos.add(Config.genericConfig());
            } else {
                configInfos.add(aConfig);
            }
            os[i] = aConfig.getOs();
            ws[i] = aConfig.getWs();
            archs[i] = aConfig.getArch();
        }
        SiteManager.setOS((String)Utils.getStringFromArray(os, ","));
        SiteManager.setWS((String)Utils.getStringFromArray(ws, ","));
        SiteManager.setOSArch((String)Utils.getStringFromArray(archs, ","));
    }

    public void setWorkingDirectory(String location) {
        workingDirectory = location;
    }

    public String getLocation(BundleDescription model) throws CoreException {
        return model.getLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String location, String fileName, int errorLevel) throws CoreException {
        Properties result = new Properties();
        File file = new File(location, fileName);
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            try {
                result.load(input);
            }
            finally {
                ((InputStream)input).close();
            }
        }
        catch (FileNotFoundException e) {
            if (errorLevel != 1 && errorLevel != 0) {
                String message = Policy.bind("exception.missingFile", file.toString());
                BundleHelper.getDefault().getLog().log((IStatus)new Status(errorLevel, "org.eclipse.pde.build", 10, message, null));
            }
        }
        catch (IOException e) {
            String message = Policy.bind("exception.readingFile", file.toString());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
        return result;
    }

    public void openScript(String scriptLocation, String scriptName) throws CoreException {
        if (this.script != null) {
            return;
        }
        try {
            BufferedOutputStream scriptStream = new BufferedOutputStream(new FileOutputStream(scriptLocation + '/' + scriptName));
            try {
                this.script = new AntScript(scriptStream);
            }
            catch (IOException e) {
                try {
                    ((OutputStream)scriptStream).close();
                    String message = Policy.bind("exception.writingFile", scriptLocation + '/' + scriptName);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                }
                catch (IOException e1) {}
            }
        }
        catch (FileNotFoundException e) {
            String message = Policy.bind("exception.writingFile", scriptLocation + '/' + scriptName);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
    }

    public void closeScript() {
        this.script.close();
    }

    public void setBuildingOSGi(boolean b) {
        buildingOSGi = b;
    }

    public static boolean isBuildingOSGi() {
        return buildingOSGi;
    }

    public static String getWorkingDirectory() {
        return workingDirectory;
    }

    public static String getDefaultOutputFormat() {
        return "zip";
    }

    public static void setOutputFormat(String format) {
        outputFormat = format;
    }

    public static boolean getDefaultEmbeddedSource() {
        return false;
    }

    public static void setEmbeddedSource(boolean embed) {
        embeddedSource = embed;
    }

    public static boolean getForceUpdateJarFormat() {
        return false;
    }

    public static void setForceUpdateJar(boolean force) {
        forceUpdateJarFormat = force;
    }

    public static String getDefaultConfigInfos() {
        return "*, *, *";
    }

    public static boolean getDefaultBuildingOSGi() {
        return true;
    }

    static {
        buildingOSGi = true;
        configInfos = new ArrayList(1);
        configInfos.add(Config.genericConfig());
    }
}

