/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.VerticalRulerEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class CompositeRuler
implements IVerticalRuler,
IVerticalRulerExtension,
IVerticalRulerInfoExtension {
    private ITextViewer fTextViewer;
    private CompositeRulerCanvas fComposite;
    private IAnnotationModel fModel;
    private List fDecorators = new ArrayList(2);
    private Point fLocation = new Point(-1, -1);
    private int fLastMouseButtonActivityLine = -1;
    private int fGap;
    private Set fAnnotationListeners = new HashSet();
    static /* synthetic */ Class class$org$eclipse$swt$events$ControlListener;
    static /* synthetic */ Class class$org$eclipse$swt$events$FocusListener;
    static /* synthetic */ Class class$org$eclipse$swt$events$HelpListener;
    static /* synthetic */ Class class$org$eclipse$swt$events$KeyListener;
    static /* synthetic */ Class class$org$eclipse$swt$events$MouseListener;
    static /* synthetic */ Class class$org$eclipse$swt$events$MouseMoveListener;
    static /* synthetic */ Class class$org$eclipse$swt$events$MouseTrackListener;
    static /* synthetic */ Class class$org$eclipse$swt$events$PaintListener;
    static /* synthetic */ Class class$org$eclipse$swt$events$TraverseListener;
    static /* synthetic */ Class class$org$eclipse$swt$events$DisposeListener;

    public CompositeRuler() {
        this(0);
    }

    public CompositeRuler(int gap) {
        this.fGap = gap;
    }

    public void addDecorator(int index, IVerticalRulerColumn rulerColumn) {
        if (index > this.fDecorators.size()) {
            this.fDecorators.add(rulerColumn);
        } else {
            this.fDecorators.add(index, rulerColumn);
        }
        if (this.fComposite != null && !this.fComposite.isDisposed()) {
            rulerColumn.createControl(this, (Composite)this.fComposite);
            this.fComposite.childAdded(rulerColumn.getControl());
            this.layoutTextViewer();
        }
    }

    public void removeDecorator(int index) {
        IVerticalRulerColumn rulerColumn = (IVerticalRulerColumn)this.fDecorators.get(index);
        this.removeDecorator(rulerColumn);
    }

    public void removeDecorator(IVerticalRulerColumn rulerColumn) {
        Control cc;
        this.fDecorators.remove(rulerColumn);
        if (rulerColumn != null && (cc = rulerColumn.getControl()) != null && !cc.isDisposed()) {
            this.fComposite.childRemoved(cc);
            cc.dispose();
        }
        this.layoutTextViewer();
    }

    private void layoutTextViewer() {
        StyledText parent = this.fTextViewer.getTextWidget();
        if (this.fTextViewer instanceof ITextViewerExtension) {
            ITextViewerExtension extension = (ITextViewerExtension)((Object)this.fTextViewer);
            parent = extension.getControl();
        }
        if (parent instanceof Composite && !parent.isDisposed()) {
            ((Composite)parent).layout(true);
        }
    }

    public Control getControl() {
        return this.fComposite;
    }

    public Control createControl(Composite parent, ITextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.fComposite = new CompositeRulerCanvas(parent, 0);
        this.fComposite.setLayout(new RulerLayout());
        Iterator iter = this.fDecorators.iterator();
        while (iter.hasNext()) {
            IVerticalRulerColumn column = (IVerticalRulerColumn)iter.next();
            column.createControl(this, (Composite)this.fComposite);
            this.fComposite.childAdded(column.getControl());
        }
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CompositeRuler.this.fTextViewer = null;
                CompositeRuler.this.fComposite = null;
                CompositeRuler.this.fModel = null;
                CompositeRuler.this.fDecorators.clear();
            }
        });
        return this.fComposite;
    }

    public void setModel(IAnnotationModel model) {
        this.fModel = model;
        Iterator e = this.fDecorators.iterator();
        while (e.hasNext()) {
            IVerticalRulerColumn column = (IVerticalRulerColumn)e.next();
            column.setModel(model);
        }
    }

    public IAnnotationModel getModel() {
        return this.fModel;
    }

    public void update() {
        Display d;
        if (this.fComposite != null && !this.fComposite.isDisposed() && (d = this.fComposite.getDisplay()) != null) {
            d.asyncExec(new Runnable(){

                public void run() {
                    Iterator e = CompositeRuler.this.fDecorators.iterator();
                    while (e.hasNext()) {
                        IVerticalRulerColumn column = (IVerticalRulerColumn)e.next();
                        column.redraw();
                    }
                }
            });
        }
    }

    public void setFont(Font font) {
        Iterator e = this.fDecorators.iterator();
        while (e.hasNext()) {
            IVerticalRulerColumn column = (IVerticalRulerColumn)e.next();
            column.setFont(font);
        }
    }

    public int getWidth() {
        int width = 0;
        Iterator e = this.fDecorators.iterator();
        while (e.hasNext()) {
            IVerticalRulerColumn column = (IVerticalRulerColumn)e.next();
            width += column.getWidth() + this.fGap;
        }
        return Math.max(0, width - this.fGap);
    }

    public int getLineOfLastMouseButtonActivity() {
        if (this.fLastMouseButtonActivityLine == -1) {
            this.fLastMouseButtonActivityLine = this.toDocumentLineNumber(this.fLocation.y);
        }
        return this.fLastMouseButtonActivityLine;
    }

    public int toDocumentLineNumber(int y_coordinate) {
        if (this.fTextViewer == null || y_coordinate == -1) {
            return -1;
        }
        StyledText text = this.fTextViewer.getTextWidget();
        int line = (y_coordinate + text.getTopPixel()) / text.getLineHeight();
        return CompositeRuler.widgetLine2ModelLine(this.fTextViewer, line);
    }

    protected static final int widgetLine2ModelLine(ITextViewer viewer, int widgetLine) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)viewer);
            return extension.widgetLine2ModelLine(widgetLine);
        }
        try {
            IRegion r = viewer.getVisibleRegion();
            IDocument d = viewer.getDocument();
            return widgetLine += d.getLineOfOffset(r.getOffset());
        }
        catch (BadLocationException badLocationException) {
            return widgetLine;
        }
    }

    public ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    public void setLocationOfLastMouseButtonActivity(int x, int y) {
        this.fLocation.x = x;
        this.fLocation.y = y;
        this.fLastMouseButtonActivityLine = -1;
    }

    public Iterator getDecoratorIterator() {
        Assert.isNotNull((Object)this.fDecorators, (String)"fDecorators must be initialized");
        return this.fDecorators.iterator();
    }

    public IAnnotationHover getHover() {
        return null;
    }

    public void addVerticalRulerListener(IVerticalRulerListener listener) {
        this.fAnnotationListeners.add(listener);
    }

    public void removeVerticalRulerListener(IVerticalRulerListener listener) {
        this.fAnnotationListeners.remove(listener);
    }

    public void fireAnnotationSelected(VerticalRulerEvent event) {
        Iterator it = this.fAnnotationListeners.iterator();
        while (it.hasNext()) {
            IVerticalRulerListener listener = (IVerticalRulerListener)it.next();
            listener.annotationSelected(event);
        }
    }

    public void fireAnnotationDefaultSelected(VerticalRulerEvent event) {
        Iterator it = this.fAnnotationListeners.iterator();
        while (it.hasNext()) {
            IVerticalRulerListener listener = (IVerticalRulerListener)it.next();
            listener.annotationDefaultSelected(event);
        }
    }

    public void fireAnnotationContextMenuAboutToShow(VerticalRulerEvent event, Menu menu) {
        Iterator it = this.fAnnotationListeners.iterator();
        while (it.hasNext()) {
            IVerticalRulerListener listener = (IVerticalRulerListener)it.next();
            listener.annotationContextMenuAboutToShow(event, menu);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class CompositeRulerCanvas
    extends Canvas {
        private List fCachedListeners = new ArrayList();
        private Listener fMenuDetectListener = new Listener(this){
            private final /* synthetic */ CompositeRulerCanvas this$0;
            {
                this.this$0 = this$0;
            }

            public void handleEvent(Event event) {
                Menu menu;
                if (event.type == 35 && (menu = this.this$0.getMenu()) != null) {
                    menu.setLocation(event.x, event.y);
                    menu.setVisible(true);
                }
            }
        };

        public CompositeRulerCanvas(Composite parent, int style) {
            super(parent, style);
            super.addDisposeListener(new DisposeListener(this){
                private final /* synthetic */ CompositeRulerCanvas this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetDisposed(DisposeEvent e) {
                    if (CompositeRulerCanvas.access$200(this.this$0) != null) {
                        CompositeRulerCanvas.access$200(this.this$0).clear();
                        CompositeRulerCanvas.access$202(this.this$0, null);
                    }
                }
            });
        }

        private void addListener(Class clazz, Control control, SWTEventListener listener) {
            if ((class$org$eclipse$swt$events$ControlListener == null ? (class$org$eclipse$swt$events$ControlListener = CompositeRuler.class$("org.eclipse.swt.events.ControlListener")) : class$org$eclipse$swt$events$ControlListener).equals(clazz)) {
                control.addControlListener((ControlListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$FocusListener == null ? (class$org$eclipse$swt$events$FocusListener = CompositeRuler.class$("org.eclipse.swt.events.FocusListener")) : class$org$eclipse$swt$events$FocusListener).equals(clazz)) {
                control.addFocusListener((FocusListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$HelpListener == null ? (class$org$eclipse$swt$events$HelpListener = CompositeRuler.class$("org.eclipse.swt.events.HelpListener")) : class$org$eclipse$swt$events$HelpListener).equals(clazz)) {
                control.addHelpListener((HelpListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$KeyListener == null ? (class$org$eclipse$swt$events$KeyListener = CompositeRuler.class$("org.eclipse.swt.events.KeyListener")) : class$org$eclipse$swt$events$KeyListener).equals(clazz)) {
                control.addKeyListener((KeyListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$MouseListener == null ? (class$org$eclipse$swt$events$MouseListener = CompositeRuler.class$("org.eclipse.swt.events.MouseListener")) : class$org$eclipse$swt$events$MouseListener).equals(clazz)) {
                control.addMouseListener((MouseListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$MouseMoveListener == null ? (class$org$eclipse$swt$events$MouseMoveListener = CompositeRuler.class$("org.eclipse.swt.events.MouseMoveListener")) : class$org$eclipse$swt$events$MouseMoveListener).equals(clazz)) {
                control.addMouseMoveListener((MouseMoveListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$MouseTrackListener == null ? (class$org$eclipse$swt$events$MouseTrackListener = CompositeRuler.class$("org.eclipse.swt.events.MouseTrackListener")) : class$org$eclipse$swt$events$MouseTrackListener).equals(clazz)) {
                control.addMouseTrackListener((MouseTrackListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$PaintListener == null ? (class$org$eclipse$swt$events$PaintListener = CompositeRuler.class$("org.eclipse.swt.events.PaintListener")) : class$org$eclipse$swt$events$PaintListener).equals(clazz)) {
                control.addPaintListener((PaintListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$TraverseListener == null ? (class$org$eclipse$swt$events$TraverseListener = CompositeRuler.class$("org.eclipse.swt.events.TraverseListener")) : class$org$eclipse$swt$events$TraverseListener).equals(clazz)) {
                control.addTraverseListener((TraverseListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$DisposeListener == null ? (class$org$eclipse$swt$events$DisposeListener = CompositeRuler.class$("org.eclipse.swt.events.DisposeListener")) : class$org$eclipse$swt$events$DisposeListener).equals(clazz)) {
                control.addDisposeListener((DisposeListener)listener);
                return;
            }
        }

        private void removeListener(Class clazz, Control control, SWTEventListener listener) {
            if ((class$org$eclipse$swt$events$ControlListener == null ? (class$org$eclipse$swt$events$ControlListener = CompositeRuler.class$("org.eclipse.swt.events.ControlListener")) : class$org$eclipse$swt$events$ControlListener).equals(clazz)) {
                control.removeControlListener((ControlListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$FocusListener == null ? (class$org$eclipse$swt$events$FocusListener = CompositeRuler.class$("org.eclipse.swt.events.FocusListener")) : class$org$eclipse$swt$events$FocusListener).equals(clazz)) {
                control.removeFocusListener((FocusListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$HelpListener == null ? (class$org$eclipse$swt$events$HelpListener = CompositeRuler.class$("org.eclipse.swt.events.HelpListener")) : class$org$eclipse$swt$events$HelpListener).equals(clazz)) {
                control.removeHelpListener((HelpListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$KeyListener == null ? (class$org$eclipse$swt$events$KeyListener = CompositeRuler.class$("org.eclipse.swt.events.KeyListener")) : class$org$eclipse$swt$events$KeyListener).equals(clazz)) {
                control.removeKeyListener((KeyListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$MouseListener == null ? (class$org$eclipse$swt$events$MouseListener = CompositeRuler.class$("org.eclipse.swt.events.MouseListener")) : class$org$eclipse$swt$events$MouseListener).equals(clazz)) {
                control.removeMouseListener((MouseListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$MouseMoveListener == null ? (class$org$eclipse$swt$events$MouseMoveListener = CompositeRuler.class$("org.eclipse.swt.events.MouseMoveListener")) : class$org$eclipse$swt$events$MouseMoveListener).equals(clazz)) {
                control.removeMouseMoveListener((MouseMoveListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$MouseTrackListener == null ? (class$org$eclipse$swt$events$MouseTrackListener = CompositeRuler.class$("org.eclipse.swt.events.MouseTrackListener")) : class$org$eclipse$swt$events$MouseTrackListener).equals(clazz)) {
                control.removeMouseTrackListener((MouseTrackListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$PaintListener == null ? (class$org$eclipse$swt$events$PaintListener = CompositeRuler.class$("org.eclipse.swt.events.PaintListener")) : class$org$eclipse$swt$events$PaintListener).equals(clazz)) {
                control.removePaintListener((PaintListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$TraverseListener == null ? (class$org$eclipse$swt$events$TraverseListener = CompositeRuler.class$("org.eclipse.swt.events.TraverseListener")) : class$org$eclipse$swt$events$TraverseListener).equals(clazz)) {
                control.removeTraverseListener((TraverseListener)listener);
                return;
            }
            if ((class$org$eclipse$swt$events$DisposeListener == null ? (class$org$eclipse$swt$events$DisposeListener = CompositeRuler.class$("org.eclipse.swt.events.DisposeListener")) : class$org$eclipse$swt$events$DisposeListener).equals(clazz)) {
                control.removeDisposeListener((DisposeListener)listener);
                return;
            }
        }

        private void addListener(Class clazz, SWTEventListener listener) {
            Control[] children = this.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i] == null || children[i].isDisposed()) continue;
                this.addListener(clazz, children[i], listener);
            }
            ListenerInfo info = new ListenerInfo();
            info.fClass = clazz;
            info.fListener = listener;
            this.fCachedListeners.add(info);
        }

        private void removeListener(Class clazz, SWTEventListener listener) {
            int length = this.fCachedListeners.size();
            for (int i = 0; i < length; ++i) {
                ListenerInfo info = (ListenerInfo)this.fCachedListeners.get(i);
                if (listener != info.fListener || !clazz.equals(info.fClass)) continue;
                this.fCachedListeners.remove(i);
                break;
            }
            Control[] children = this.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i] == null || children[i].isDisposed()) continue;
                this.removeListener(clazz, children[i], listener);
            }
        }

        public void childAdded(Control child) {
            if (child != null && !child.isDisposed()) {
                int length = this.fCachedListeners.size();
                for (int i = 0; i < length; ++i) {
                    ListenerInfo info = (ListenerInfo)this.fCachedListeners.get(i);
                    this.addListener(info.fClass, child, info.fListener);
                }
                child.addListener(35, this.fMenuDetectListener);
            }
        }

        public void childRemoved(Control child) {
            if (child != null && !child.isDisposed()) {
                int length = this.fCachedListeners.size();
                for (int i = 0; i < length; ++i) {
                    ListenerInfo info = (ListenerInfo)this.fCachedListeners.get(i);
                    this.removeListener(info.fClass, child, info.fListener);
                }
                child.removeListener(35, this.fMenuDetectListener);
            }
        }

        public void removeControlListener(ControlListener listener) {
            this.removeListener(class$org$eclipse$swt$events$ControlListener == null ? (class$org$eclipse$swt$events$ControlListener = CompositeRuler.class$("org.eclipse.swt.events.ControlListener")) : class$org$eclipse$swt$events$ControlListener, (SWTEventListener)listener);
            super.removeControlListener(listener);
        }

        public void removeFocusListener(FocusListener listener) {
            this.removeListener(class$org$eclipse$swt$events$FocusListener == null ? (class$org$eclipse$swt$events$FocusListener = CompositeRuler.class$("org.eclipse.swt.events.FocusListener")) : class$org$eclipse$swt$events$FocusListener, (SWTEventListener)listener);
            super.removeFocusListener(listener);
        }

        public void removeHelpListener(HelpListener listener) {
            this.removeListener(class$org$eclipse$swt$events$HelpListener == null ? (class$org$eclipse$swt$events$HelpListener = CompositeRuler.class$("org.eclipse.swt.events.HelpListener")) : class$org$eclipse$swt$events$HelpListener, (SWTEventListener)listener);
            super.removeHelpListener(listener);
        }

        public void removeKeyListener(KeyListener listener) {
            this.removeListener(class$org$eclipse$swt$events$KeyListener == null ? (class$org$eclipse$swt$events$KeyListener = CompositeRuler.class$("org.eclipse.swt.events.KeyListener")) : class$org$eclipse$swt$events$KeyListener, (SWTEventListener)listener);
            super.removeKeyListener(listener);
        }

        public void removeMouseListener(MouseListener listener) {
            this.removeListener(class$org$eclipse$swt$events$MouseListener == null ? (class$org$eclipse$swt$events$MouseListener = CompositeRuler.class$("org.eclipse.swt.events.MouseListener")) : class$org$eclipse$swt$events$MouseListener, (SWTEventListener)listener);
            super.removeMouseListener(listener);
        }

        public void removeMouseMoveListener(MouseMoveListener listener) {
            this.removeListener(class$org$eclipse$swt$events$MouseMoveListener == null ? (class$org$eclipse$swt$events$MouseMoveListener = CompositeRuler.class$("org.eclipse.swt.events.MouseMoveListener")) : class$org$eclipse$swt$events$MouseMoveListener, (SWTEventListener)listener);
            super.removeMouseMoveListener(listener);
        }

        public void removeMouseTrackListener(MouseTrackListener listener) {
            this.removeListener(class$org$eclipse$swt$events$MouseTrackListener == null ? (class$org$eclipse$swt$events$MouseTrackListener = CompositeRuler.class$("org.eclipse.swt.events.MouseTrackListener")) : class$org$eclipse$swt$events$MouseTrackListener, (SWTEventListener)listener);
            super.removeMouseTrackListener(listener);
        }

        public void removePaintListener(PaintListener listener) {
            this.removeListener(class$org$eclipse$swt$events$PaintListener == null ? (class$org$eclipse$swt$events$PaintListener = CompositeRuler.class$("org.eclipse.swt.events.PaintListener")) : class$org$eclipse$swt$events$PaintListener, (SWTEventListener)listener);
            super.removePaintListener(listener);
        }

        public void removeTraverseListener(TraverseListener listener) {
            this.removeListener(class$org$eclipse$swt$events$TraverseListener == null ? (class$org$eclipse$swt$events$TraverseListener = CompositeRuler.class$("org.eclipse.swt.events.TraverseListener")) : class$org$eclipse$swt$events$TraverseListener, (SWTEventListener)listener);
            super.removeTraverseListener(listener);
        }

        public void removeDisposeListener(DisposeListener listener) {
            this.removeListener(class$org$eclipse$swt$events$DisposeListener == null ? (class$org$eclipse$swt$events$DisposeListener = CompositeRuler.class$("org.eclipse.swt.events.DisposeListener")) : class$org$eclipse$swt$events$DisposeListener, (SWTEventListener)listener);
            super.removeDisposeListener(listener);
        }

        public void addControlListener(ControlListener listener) {
            super.addControlListener(listener);
            this.addListener(class$org$eclipse$swt$events$ControlListener == null ? (class$org$eclipse$swt$events$ControlListener = CompositeRuler.class$("org.eclipse.swt.events.ControlListener")) : class$org$eclipse$swt$events$ControlListener, (SWTEventListener)listener);
        }

        public void addFocusListener(FocusListener listener) {
            super.addFocusListener(listener);
            this.addListener(class$org$eclipse$swt$events$FocusListener == null ? (class$org$eclipse$swt$events$FocusListener = CompositeRuler.class$("org.eclipse.swt.events.FocusListener")) : class$org$eclipse$swt$events$FocusListener, (SWTEventListener)listener);
        }

        public void addHelpListener(HelpListener listener) {
            super.addHelpListener(listener);
            this.addListener(class$org$eclipse$swt$events$HelpListener == null ? (class$org$eclipse$swt$events$HelpListener = CompositeRuler.class$("org.eclipse.swt.events.HelpListener")) : class$org$eclipse$swt$events$HelpListener, (SWTEventListener)listener);
        }

        public void addKeyListener(KeyListener listener) {
            super.addKeyListener(listener);
            this.addListener(class$org$eclipse$swt$events$KeyListener == null ? (class$org$eclipse$swt$events$KeyListener = CompositeRuler.class$("org.eclipse.swt.events.KeyListener")) : class$org$eclipse$swt$events$KeyListener, (SWTEventListener)listener);
        }

        public void addMouseListener(MouseListener listener) {
            super.addMouseListener(listener);
            this.addListener(class$org$eclipse$swt$events$MouseListener == null ? (class$org$eclipse$swt$events$MouseListener = CompositeRuler.class$("org.eclipse.swt.events.MouseListener")) : class$org$eclipse$swt$events$MouseListener, (SWTEventListener)listener);
        }

        public void addMouseMoveListener(MouseMoveListener listener) {
            super.addMouseMoveListener(listener);
            this.addListener(class$org$eclipse$swt$events$MouseMoveListener == null ? (class$org$eclipse$swt$events$MouseMoveListener = CompositeRuler.class$("org.eclipse.swt.events.MouseMoveListener")) : class$org$eclipse$swt$events$MouseMoveListener, (SWTEventListener)listener);
        }

        public void addMouseTrackListener(MouseTrackListener listener) {
            super.addMouseTrackListener(listener);
            this.addListener(class$org$eclipse$swt$events$MouseTrackListener == null ? (class$org$eclipse$swt$events$MouseTrackListener = CompositeRuler.class$("org.eclipse.swt.events.MouseTrackListener")) : class$org$eclipse$swt$events$MouseTrackListener, (SWTEventListener)listener);
        }

        public void addPaintListener(PaintListener listener) {
            super.addPaintListener(listener);
            this.addListener(class$org$eclipse$swt$events$PaintListener == null ? (class$org$eclipse$swt$events$PaintListener = CompositeRuler.class$("org.eclipse.swt.events.PaintListener")) : class$org$eclipse$swt$events$PaintListener, (SWTEventListener)listener);
        }

        public void addTraverseListener(TraverseListener listener) {
            super.addTraverseListener(listener);
            this.addListener(class$org$eclipse$swt$events$TraverseListener == null ? (class$org$eclipse$swt$events$TraverseListener = CompositeRuler.class$("org.eclipse.swt.events.TraverseListener")) : class$org$eclipse$swt$events$TraverseListener, (SWTEventListener)listener);
        }

        public void addDisposeListener(DisposeListener listener) {
            super.addDisposeListener(listener);
            this.addListener(class$org$eclipse$swt$events$DisposeListener == null ? (class$org$eclipse$swt$events$DisposeListener = CompositeRuler.class$("org.eclipse.swt.events.DisposeListener")) : class$org$eclipse$swt$events$DisposeListener, (SWTEventListener)listener);
        }

        static /* synthetic */ List access$200(CompositeRulerCanvas x0) {
            return x0.fCachedListeners;
        }

        static /* synthetic */ List access$202(CompositeRulerCanvas x0, List x1) {
            x0.fCachedListeners = x1;
            return x0.fCachedListeners;
        }

        static class ListenerInfo {
            Class fClass;
            SWTEventListener fListener;

            ListenerInfo() {
            }
        }
    }

    class RulerLayout
    extends Layout {
        protected RulerLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point size = new Point(0, 0);
            for (int i = 0; i < children.length; ++i) {
                Point s = children[i].computeSize(-1, -1, flushCache);
                size.x += s.x;
                size.y = Math.max(size.y, s.y);
            }
            size.x += Math.max(0, children.length - 1) * CompositeRuler.this.fGap;
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clArea = composite.getClientArea();
            int rulerHeight = clArea.height;
            int x = 0;
            Iterator e = CompositeRuler.this.fDecorators.iterator();
            while (e.hasNext()) {
                IVerticalRulerColumn column = (IVerticalRulerColumn)e.next();
                int columnWidth = column.getWidth();
                column.getControl().setBounds(x, 0, columnWidth, rulerHeight);
                x += columnWidth + CompositeRuler.this.fGap;
            }
        }
    }
}

