/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh2;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.ssh2.Policy;

class ExportDialog
extends Dialog {
    protected Text field;
    protected String target = null;
    protected String title = null;
    protected String message = null;

    public ExportDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this.title = title;
        this.message = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    public void create() {
        super.create();
        this.field.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        parent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(768));
        Composite main = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        if (this.message != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setText(this.message);
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            messageLabel.setLayoutData((Object)data);
        }
        this.createTargetFields(main);
        Dialog.applyDialogFont((Control)main);
        return main;
    }

    protected void createTargetFields(Composite parent) {
        new Label(parent, 0).setText(Policy.bind("CVSSSH2PreferencePage.125"));
        this.field = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        data.horizontalSpan = 2;
        this.field.setLayoutData((Object)data);
    }

    public String getTarget() {
        return this.target;
    }

    protected void okPressed() {
        String _target = this.field.getText();
        if (_target == null || _target.length() == 0) {
            return;
        }
        this.target = _target;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.target = null;
        super.cancelPressed();
    }
}

