/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IContext;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.HelpResources;
import org.eclipse.help.internal.context.ContextsBuilder;
import org.eclipse.help.internal.context.ContextsFile;
import org.eclipse.help.internal.context.PluginContexts;
import org.eclipse.help.internal.context.PluginsContexts;

public class ContextManager
implements IRegistryChangeListener {
    public static final String CONTEXTS_XP_NAME = "contexts";
    public static final String CONTEXTS_XP_FULLNAME = "org.eclipse.help.contexts";
    PluginsContexts pluginsContexts = new PluginsContexts();
    Map contextsFiles = new HashMap();
    Map dynamicContextIDs = new HashMap();
    private int idCounter = 0;

    public ContextManager() {
        this.createContextsFiles();
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.help");
    }

    public IContext getContext(String contextId) {
        if (HelpPlugin.DEBUG_CONTEXT) {
            System.out.println("ContextManager.getContext(" + contextId + ")");
        }
        if (contextId == null) {
            return null;
        }
        String plugin = contextId;
        String id = contextId;
        int dot = contextId.lastIndexOf(46);
        if (dot <= 0 || dot >= contextId.length() - 1) {
            return null;
        }
        plugin = contextId.substring(0, dot);
        id = contextId.substring(dot + 1);
        PluginContexts contexts = this.pluginsContexts.get(plugin);
        if (contexts == null) {
            contexts = this.loadPluginContexts(plugin);
        }
        return contexts.get(id);
    }

    private synchronized PluginContexts loadPluginContexts(String plugin) {
        PluginContexts contexts = this.pluginsContexts.get(plugin);
        if (contexts == null) {
            contexts = new PluginContexts();
            ArrayList pluginContextsFiles = (ArrayList)this.contextsFiles.get(plugin);
            if (pluginContextsFiles == null) {
                pluginContextsFiles = new ArrayList();
            }
            ContextsBuilder builder = new ContextsBuilder(contexts);
            builder.build(pluginContextsFiles);
            this.pluginsContexts.put(plugin, contexts);
        }
        return contexts;
    }

    private void createContextsFiles() {
        IExtensionPoint xpt = Platform.getExtensionRegistry().getExtensionPoint(CONTEXTS_XP_FULLNAME);
        if (xpt == null) {
            return;
        }
        IExtension[] extensions = xpt.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            this.createContextFile(extensions[i]);
        }
    }

    private Collection createContextFile(IExtension extension) {
        HashSet<String> plugins = new HashSet<String>();
        String definingPlugin = extension.getNamespace();
        IConfigurationElement[] contextContributions = extension.getConfigurationElements();
        for (int j = 0; j < contextContributions.length; ++j) {
            String fileName;
            if (!CONTEXTS_XP_NAME.equals(contextContributions[j].getName())) continue;
            String plugin = contextContributions[j].getAttribute("plugin");
            if (plugin == null || "".equals(plugin)) {
                plugin = definingPlugin;
            }
            if ((fileName = contextContributions[j].getAttribute("file")) == null) {
                fileName = contextContributions[j].getAttribute("name");
            }
            if (fileName == null) {
                String msg = HelpResources.getString("ContextManager.FileAttribute", CONTEXTS_XP_FULLNAME, definingPlugin);
                HelpPlugin.logError(msg, null);
                continue;
            }
            ArrayList<ContextsFile> pluginContextsFiles = (ArrayList<ContextsFile>)this.contextsFiles.get(plugin);
            if (pluginContextsFiles == null) {
                pluginContextsFiles = new ArrayList<ContextsFile>();
                this.contextsFiles.put(plugin, pluginContextsFiles);
            }
            pluginContextsFiles.add(new ContextsFile(definingPlugin, fileName, plugin));
            plugins.add(plugin);
        }
        return plugins;
    }

    public String addContext(IContext context) {
        String plugin = "org.eclipse.help";
        String id = (String)this.dynamicContextIDs.get(context);
        if (id == null) {
            id = "ID" + this.idCounter++;
            this.dynamicContextIDs.put(context, id);
            PluginContexts contexts = this.pluginsContexts.get(plugin);
            if (contexts == null) {
                contexts = this.loadPluginContexts(plugin);
            }
            contexts.put(id, context);
        }
        return plugin + "." + id;
    }

    public synchronized void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.help", CONTEXTS_XP_NAME);
        for (int i = 0; i < deltas.length; ++i) {
            if (deltas[i].getKind() != 1) continue;
            IExtension extension = deltas[i].getExtension();
            Collection affectedPlugins = this.createContextFile(extension);
            Iterator it = affectedPlugins.iterator();
            while (it.hasNext()) {
                String pluginId = (String)it.next();
                this.pluginsContexts.remove(pluginId);
            }
        }
    }
}

