/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;

public class ContainerSelectionDialog
extends SelectionDialog {
    ContainerSelectionGroup group;
    private IContainer initialSelection;
    private boolean allowNewContainerName = true;
    Label statusMessage;
    ISelectionValidator validator;
    private boolean showClosedProjects = true;

    public ContainerSelectionDialog(Shell parentShell, IContainer initialRoot, boolean allowNewContainerName, String message) {
        super(parentShell);
        this.setTitle(IDEWorkbenchMessages.getString("ContainerSelectionDialog.title"));
        this.initialSelection = initialRoot;
        this.allowNewContainerName = allowNewContainerName;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(IDEWorkbenchMessages.getString("ContainerSelectionDialog.message"));
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.ui.ide.container_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (ContainerSelectionDialog.this.statusMessage != null && ContainerSelectionDialog.this.validator != null) {
                    String errorMsg = ContainerSelectionDialog.this.validator.isValid((Object)ContainerSelectionDialog.this.group.getContainerFullPath());
                    if (errorMsg == null || errorMsg.equals("")) {
                        ContainerSelectionDialog.this.statusMessage.setText("");
                        ContainerSelectionDialog.this.getOkButton().setEnabled(true);
                    } else {
                        ContainerSelectionDialog.this.statusMessage.setForeground(JFaceColors.getErrorText((Display)ContainerSelectionDialog.this.statusMessage.getDisplay()));
                        ContainerSelectionDialog.this.statusMessage.setText(errorMsg);
                        ContainerSelectionDialog.this.getOkButton().setEnabled(false);
                    }
                }
            }
        };
        this.group = new ContainerSelectionGroup(area, listener, this.allowNewContainerName, this.getMessage(), this.showClosedProjects);
        if (this.initialSelection != null) {
            this.group.setSelectedContainer(this.initialSelection);
        }
        this.statusMessage = new Label(parent, 0);
        this.statusMessage.setLayoutData((Object)new GridData(768));
        this.statusMessage.setFont(parent.getFont());
        return this.dialogArea;
    }

    protected void okPressed() {
        ArrayList<IPath> chosenContainerPathList = new ArrayList<IPath>();
        IPath returnValue = this.group.getContainerFullPath();
        if (returnValue != null) {
            chosenContainerPathList.add(returnValue);
        }
        this.setResult(chosenContainerPathList);
        super.okPressed();
    }

    public void setValidator(ISelectionValidator validator) {
        this.validator = validator;
    }

    public void showClosedProjects(boolean show) {
        this.showClosedProjects = show;
    }
}

