/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.adaptor.BundleStopper;
import org.eclipse.core.runtime.adaptor.EclipseAdaptor;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.adaptor.EclipseBundleData;
import org.eclipse.core.runtime.adaptor.EnvironmentInfo;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.BundleEntry;
import org.eclipse.osgi.framework.adaptor.core.BundleFile;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultBundleData;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultClassLoader;
import org.eclipse.osgi.framework.internal.defaultadaptor.DevClassPathHelper;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.stats.ClassloaderStats;
import org.eclipse.osgi.framework.stats.ResourceBundleStats;
import org.eclipse.osgi.framework.stats.StatsManager;
import org.osgi.framework.BundleException;

public class EclipseClassLoader
extends DefaultClassLoader {
    private static String[] NL_JAR_VARIANTS = EclipseClassLoader.buildNLJarVariants(EnvironmentInfo.getDefault().getNL());
    private static boolean DEFINE_PACKAGES;

    public EclipseClassLoader(ClassLoaderDelegate delegate, ProtectionDomain domain, String[] classpath, ClassLoader parent, BundleData bundleData) {
        super(delegate, domain, classpath, parent, (AbstractBundleData)((DefaultBundleData)bundleData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findLocalClass(String className) throws ClassNotFoundException {
        if (StatsManager.MONITOR_CLASSES) {
            ClassloaderStats.startLoadingClass(this.getClassloaderId(), className);
        }
        boolean found = true;
        try {
            AbstractBundle bundle = (AbstractBundle)this.hostdata.getBundle();
            if ((bundle.getState() & 0x31) != 0) {
                Class clazz = this.basicFindLocalClass(className);
                return clazz;
            }
            if (!this.shouldActivateFor(className)) {
                Class clazz = this.basicFindLocalClass(className);
                return clazz;
            }
            if (bundle.getState() == 8) {
                if (bundle.testStateChanging((Object)Thread.currentThread()) || bundle.testStateChanging(null)) {
                    Class clazz = this.basicFindLocalClass(className);
                    return clazz;
                }
                if (!bundle.testStateChanging((Object)Thread.currentThread())) {
                    Object object;
                    long delay;
                    Thread threadChangingState = bundle.getStateChanging();
                    if (StatsManager.TRACE_BUNDLES && threadChangingState != null) {
                        System.out.println("Concurrent startup of bundle " + bundle.getSymbolicName() + " by " + Thread.currentThread() + " and " + threadChangingState.getName() + ". Waiting up to 5000ms for " + threadChangingState + " to finish the initialization.");
                    }
                    Object lock = bundle.getStateChangeLock();
                    long start = System.currentTimeMillis();
                    long timeLeft = delay = 5000L;
                    while (!bundle.testStateChanging(null) && timeLeft > 0L) {
                        try {
                            object = lock;
                            synchronized (object) {
                                lock.wait(timeLeft);
                            }
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        timeLeft = start + delay - System.currentTimeMillis();
                    }
                    if (timeLeft <= 0L || bundle.getState() != 32) {
                        String bundleName = bundle.getSymbolicName() == null ? Long.toString(bundle.getBundleId()) : bundle.getSymbolicName();
                        String message = EclipseAdaptorMsg.formatter.getString("ECLIPSE_CLASSLOADER_CONCURRENT_STARTUP", new Object[]{Thread.currentThread().getName(), className, threadChangingState.getName(), bundleName, Long.toString(delay)});
                        EclipseAdaptor.getDefault().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", message, 0, (Throwable)new Exception(EclipseAdaptorMsg.formatter.getString("ECLIPSE_CLASSLOADER_GENERATED_EXCEPTION")), null));
                    }
                    object = this.basicFindLocalClass(className);
                    return object;
                }
            }
            try {
                this.hostdata.getBundle().start();
            }
            catch (BundleException e) {
                String message = EclipseAdaptorMsg.formatter.getString("ECLIPSE_CLASSLOADER_ACTIVATION", (Object)bundle.getSymbolicName(), (Object)Long.toString(bundle.getBundleId()));
                EclipseAdaptor.getDefault().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", message, 0, (Throwable)e, null));
                throw new ClassNotFoundException(className, e);
            }
            Class clazz = this.basicFindLocalClass(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            found = false;
            throw e;
        }
        finally {
            if (StatsManager.MONITOR_CLASSES) {
                ClassloaderStats.endLoadingClass(this.getClassloaderId(), className, found);
            }
        }
    }

    protected Class basicFindLocalClass(String name) throws ClassNotFoundException {
        return super.findLocalClass(name);
    }

    private boolean shouldActivateFor(String className) throws ClassNotFoundException {
        BundleStopper stopper;
        if (this.hostdata.getAdaptor().isStopping() && (stopper = EclipseAdaptor.getDefault().getBundleStopper()) != null && stopper.isStopped(this.hostdata.getBundle())) {
            String message = EclipseAdaptorMsg.formatter.getString("ECLIPSE_CLASSLOADER_ALREADY_STOPPED", (Object)className, (Object)this.hostdata.getSymbolicName());
            ClassNotFoundException exception = new ClassNotFoundException(message);
            EclipseAdaptor.getDefault().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", message, 0, (Throwable)exception, null));
            throw exception;
        }
        boolean autoStart = ((EclipseBundleData)this.hostdata).isAutoStart();
        String[] autoStartExceptions = ((EclipseBundleData)this.hostdata).getAutoStartExceptions();
        if (autoStartExceptions == null) {
            return autoStart;
        }
        int dotPosition = className.lastIndexOf(46);
        if (dotPosition == -1) {
            return autoStart;
        }
        String packageName = className.substring(0, dotPosition);
        return autoStart ^ this.contains(autoStartExceptions, packageName);
    }

    private boolean contains(String[] array, String element) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(element)) continue;
            return true;
        }
        return false;
    }

    protected Class defineClass(String name, byte[] classbytes, int off, int len, DefaultClassLoader.ClasspathEntry classpathEntry) throws ClassFormatError {
        String packageName;
        Package pkg;
        if (!DEFINE_PACKAGES) {
            return super.defineClass(name, classbytes, off, len, classpathEntry);
        }
        int lastIndex = name.lastIndexOf(46);
        if (lastIndex != -1 && (pkg = this.getPackage(packageName = name.substring(0, lastIndex))) == null) {
            String specTitle = null;
            String specVersion = null;
            String specVendor = null;
            String implTitle = null;
            String implVersion = null;
            String implVendor = null;
            Manifest mf = ((EclipseClasspathEntry)classpathEntry).getManifest();
            if (mf != null) {
                Attributes mainAttributes = mf.getMainAttributes();
                String dirName = packageName.replace('.', '/') + '/';
                Attributes packageAttributes = mf.getAttributes(dirName);
                boolean noEntry = false;
                if (packageAttributes == null) {
                    noEntry = true;
                    packageAttributes = mainAttributes;
                }
                if ((specTitle = packageAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE)) == null && !noEntry) {
                    specTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                }
                if ((specVersion = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION)) == null && !noEntry) {
                    specVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                }
                if ((specVendor = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR)) == null && !noEntry) {
                    specVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                }
                if ((implTitle = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE)) == null && !noEntry) {
                    implTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                }
                if ((implVersion = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION)) == null && !noEntry) {
                    implVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                }
                if ((implVendor = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR)) == null && !noEntry) {
                    implVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                }
            }
            this.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
        }
        return super.defineClass(name, classbytes, off, len, classpathEntry);
    }

    private String getClassloaderId() {
        return this.hostdata.getBundle().getSymbolicName();
    }

    public URL getResource(String name) {
        URL result = super.getResource(name);
        if (StatsManager.MONITOR_RESOURCES && result != null && name.endsWith(".properties")) {
            ClassloaderStats.loadedBundle(this.getClassloaderId(), new ResourceBundleStats(this.getClassloaderId(), name, result));
        }
        return result;
    }

    protected void findClassPathEntry(ArrayList result, String entry, AbstractBundleData bundledata, ProtectionDomain domain) {
        String var = this.hasPrefix(entry);
        if (var == null) {
            super.findClassPathEntry(result, entry, bundledata, domain);
            return;
        }
        if (var.equals("ws")) {
            super.findClassPathEntry(result, "ws/" + EnvironmentInfo.getDefault().getWS() + entry.substring(4), bundledata, domain);
            return;
        }
        if (var.equals("os")) {
            super.findClassPathEntry(result, "os/" + EnvironmentInfo.getDefault().getOS() + entry.substring(4), bundledata, domain);
            return;
        }
        if (var.equals("nl")) {
            entry = entry.substring(4);
            for (int i = 0; i < NL_JAR_VARIANTS.length; ++i) {
                if (!this.addClassPathEntry(result, "nl/" + NL_JAR_VARIANTS[i] + entry, bundledata, domain)) continue;
                return;
            }
            if (!DevClassPathHelper.inDevelopmentMode()) {
                BundleException be = new BundleException(Msg.formatter.getString("BUNDLE_CLASSPATH_ENTRY_NOT_FOUND_EXCEPTION", (Object)entry, (Object)this.hostdata.getLocation()));
                bundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, bundledata.getBundle(), (Throwable)be);
            }
        }
    }

    private static String[] buildNLJarVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    private String hasPrefix(String libPath) {
        if (libPath.startsWith("$ws$")) {
            return "ws";
        }
        if (libPath.startsWith("$os$")) {
            return "os";
        }
        if (libPath.startsWith("$nl$")) {
            return "nl";
        }
        return null;
    }

    protected DefaultClassLoader.ClasspathEntry createClassPathEntry(BundleFile bundlefile, ProtectionDomain domain) {
        return new EclipseClasspathEntry(bundlefile, domain);
    }

    static {
        try {
            Class.forName("java.lang.Package");
            DEFINE_PACKAGES = true;
        }
        catch (ClassNotFoundException e) {
            DEFINE_PACKAGES = false;
        }
    }

    protected class EclipseClasspathEntry
    extends DefaultClassLoader.ClasspathEntry {
        Manifest mf;
        boolean initMF = false;

        protected EclipseClasspathEntry(BundleFile bundlefile, ProtectionDomain domain) {
            super((DefaultClassLoader)EclipseClassLoader.this, bundlefile, domain);
        }

        public Manifest getManifest() {
            if (this.initMF) {
                return this.mf;
            }
            BundleEntry mfEntry = this.getBundleFile().getEntry("META-INF/MANIFEST.MF");
            if (mfEntry != null) {
                try {
                    InputStream manIn = mfEntry.getInputStream();
                    this.mf = new Manifest(manIn);
                    manIn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.initMF = true;
            return this.mf;
        }
    }
}

