/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.parts.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class BaseNewDialog
extends StatusDialog {
    private Button okButton;
    private ISiteModel siteModel;
    private ISiteObject siteObject;
    private IStatus errorStatus;
    private IStatus okStatus;

    public BaseNewDialog(Shell shell, ISiteModel siteModel, ISiteObject siteObject) {
        super(shell);
        this.siteModel = siteModel;
        this.siteObject = siteObject;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.dialogChanged();
    }

    public ISiteObject getSiteObject() {
        return this.siteObject;
    }

    public ISiteModel getSiteModel() {
        return this.siteModel;
    }

    protected IDialogSettings getDialogSettings(String sectionName) {
        IDialogSettings master = PDEPlugin.getDefault().getDialogSettings();
        IDialogSettings section = master.getSection(sectionName);
        if (section == null) {
            section = master.addNewSection(sectionName);
        }
        return section;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createEntries(container);
        if (this.siteObject != null) {
            this.initializeFields();
        }
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseNewDialog.this.dialogChanged();
            }
        };
        this.hookListeners(listener);
        this.setTitle(this.getDialogTitle());
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)this.getHelpId());
        return container;
    }

    protected abstract String getDialogTitle();

    protected abstract String getHelpId();

    protected abstract void createEntries(Composite var1);

    protected abstract void hookListeners(ModifyListener var1);

    protected abstract void dialogChanged();

    protected abstract String getEmptyErrorMessage();

    protected void initializeFields() {
        if (!this.siteModel.isEditable()) {
            this.okButton.setEnabled(false);
        }
    }

    protected void setIfDefined(Text text, String value) {
        if (value != null) {
            text.setText(value);
        }
    }

    protected IStatus getEmptyErrorStatus() {
        if (this.errorStatus == null) {
            this.errorStatus = this.createErrorStatus(this.getEmptyErrorMessage());
        }
        return this.errorStatus;
    }

    protected IStatus getOKStatus() {
        if (this.okStatus == null) {
            this.okStatus = new Status(0, PDEPlugin.getPluginId(), 0, "", null);
        }
        return this.okStatus;
    }

    protected IStatus createErrorStatus(String message) {
        return new Status(4, PDEPlugin.getPluginId(), 0, message, null);
    }

    protected void okPressed() {
        this.execute();
        super.okPressed();
    }

    protected abstract void execute();
}

