/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.vmconversion;

import com.amazon.aes.webservices.client.vmconversionschema.Part;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;

public class Slice {
    private final File sourceFile;
    private final Part part;
    private File file = null;
    private byte[] md5Hash = null;

    public Slice(File sourceFile, Part part) throws IOException, NoSuchAlgorithmException {
        this.sourceFile = sourceFile;
        this.part = part;
        this.sliceOutPart();
    }

    public S3Object createS3Object(String bucketName) {
        S3Object s3Object = new S3Object(new S3Bucket(bucketName), this.part.getKey());
        s3Object.setDataInputFile(this.file);
        s3Object.setContentLength(this.file.length());
        s3Object.setMd5Hash(this.md5Hash);
        return s3Object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sliceOutPart() throws IOException, NoSuchAlgorithmException {
        this.file = File.createTempFile(this.sourceFile.getName(), ".part" + this.part.getIndex());
        this.file.deleteOnExit();
        byte[] buff = new byte[65536];
        RandomAccessFile input = null;
        FileOutputStream outputStream = null;
        try {
            int bytesRead;
            input = new RandomAccessFile(this.sourceFile, "r");
            input.seek(this.part.getByteRange().getStart());
            outputStream = new FileOutputStream(this.file);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            for (long sliceBytesToRead = this.part.getByteRange().getEnd() - this.part.getByteRange().getStart() + 1L; sliceBytesToRead > 0L; sliceBytesToRead -= (long)bytesRead) {
                int bytesToRead = sliceBytesToRead > (long)buff.length ? buff.length : (int)sliceBytesToRead;
                bytesRead = input.read(buff, 0, bytesToRead);
                if (bytesRead == -1) {
                    throw new RuntimeException("Premature end of slice reached");
                }
                outputStream.write(buff, 0, bytesRead);
                messageDigest.update(buff, 0, bytesRead);
            }
            this.md5Hash = messageDigest.digest();
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public void deleteFile() {
        this.file.delete();
        this.file = null;
    }
}

