/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.tree.AttributeCollection;
import com.nwalsh.saxon.Callout;
import com.nwalsh.saxon.FormatCallout;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class FormatUnicodeCallout
extends FormatCallout {
    int unicodeMax = 0;
    int unicodeStart = 0;
    String unicodeFont = "";

    public FormatUnicodeCallout(NamePool namePool, String string, int n, int n2, boolean bl, boolean bl2) {
        super(namePool, bl, bl2);
        this.unicodeFont = string;
        this.unicodeMax = n2;
        this.unicodeStart = n;
    }

    @Override
    public void formatCallout(Emitter emitter, Callout callout) {
        Element element = callout.getArea();
        int n = callout.getCallout();
        String string = this.areaLabel(element);
        String string2 = "";
        String string3 = this.areaID(element);
        if (string != null) {
            string2 = string;
        }
        try {
            if (string == null && n <= this.unicodeMax) {
                int n2 = 0;
                AttributeCollection attributeCollection = null;
                int[] nArray = new int[1];
                if (!this.unicodeFont.equals("")) {
                    if (this.foStylesheet) {
                        n2 = this.namePool.allocate("fo", "http://www.w3.org/1999/XSL/Format", "inline");
                        attributeCollection = new AttributeCollection(this.namePool);
                        attributeCollection.addAttribute("", "", "font-family", "CDATA", this.unicodeFont);
                        attributeCollection.addAttribute("", "", "id", "ID", string3);
                    } else {
                        n2 = this.xhStylesheet ? this.namePool.allocate("", "http://www.w3.org/1999/xhtml", "font") : this.namePool.allocate("", "", "font");
                        attributeCollection = new AttributeCollection(this.namePool);
                        attributeCollection.addAttribute("", "", "face", "CDATA", this.unicodeFont);
                        attributeCollection.addAttribute("", "", "id", "ID", string3);
                    }
                    this.startSpan(emitter, string3);
                    emitter.startElement(n2, (Attributes)attributeCollection, nArray, 0);
                }
                char[] cArray = new char[]{(char)(this.unicodeStart + n - 1)};
                emitter.characters(cArray, 0, 1);
                if (!this.unicodeFont.equals("")) {
                    emitter.endElement(n2);
                    this.endSpan(emitter);
                }
            } else {
                this.formatTextCallout(emitter, callout);
            }
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer Exception in graphic formatCallout");
        }
    }
}

