/*

Copyright (c) 2007 Carl Byington - 510 Software Group, released under
the GPL version 3 or any later version at your choice available at
http://www.gnu.org/licenses/gpl-3.0.txt

Based on spamass-milter by Georg C. F. Greve <greve@gnu.org>

*/

#ifndef _SPAMASS_H
#define _SPAMASS_H

extern "C" {
    #include <libmilter/mfapi.h>
}

#ifdef HAVE_CDEFS_H
#include <sys/cdefs.h>
#endif

#include <list>

extern const char *spamc;
extern const char *spamc_empty;
using namespace std;

class mlfiPriv;

class SpamAssassin {
public:
    SpamAssassin(mlfiPriv *priv_, int ip, const char *helo_, const char *from, const char *qid);
    ~SpamAssassin();

    void mlfi_envrcpt(SMFICTX *ctx, const char *envrcpt);
    void mlfi_header(const char* headerf, const char* headerv);
    void mlfi_eoh();
    void mlfi_body(const u_char *bodyp, size_t bodylen);
    int  mlfi_eom();

private:
    void Connect();
    void output(const char *buffer, size_t size);
    void output(const char *buffer);
    void output(string buffer);
    void close_output();
    void input();
    int  read_pipe();
    void empty_and_close_pipe();
    void closeall(int fd);
    const char *getorwarnmacro(SMFICTX *ctx, const char *macro, const char *def, const char *scope);
    void warnmacro(const char *macro, const char *scope);

public:
    bool error;             // spamc died or cannot work
    bool running;           // running implies (connected and pid)
    bool first_recipient;   // have we not seen any recipients?

    // connection back to main dnsbl priv structure for logging
    mlfiPriv *priv;
    int      ip4;           // ip4 address of smtp client

    // strings owned by main dnsbl
    const char *helo;       // client helo value
    const char *envfrom;    // envelope from value for this message
    const char *queueid;    // the sendmail queue id for this message

    // Process handling variables
    pid_t pid;
    int pipe_io[2][2];
    string spamc_output;
    string spamc_input;
};

#endif
