/*

Copyright (c) 2007 Carl Byington - 510 Software Group, released under
the GPL version 3 or any later version at your choice available at
http://www.gnu.org/licenses/gpl-3.0.txt

*/

#ifndef _DCCIFD_H
#define _DCCIFD_H

extern "C" {
    #include <libmilter/mfapi.h>
}

#ifdef HAVE_CDEFS_H
#include <sys/cdefs.h>
#endif

#include <list>

using namespace std;

class mlfiPriv;

class DccInterface {
public:
    DccInterface(const char *port_, mlfiPriv *priv_, int ip, const char *helo_, const char *from);
    ~DccInterface();

    void mlfi_envrcpt(SMFICTX *ctx, const char *envrcpt, bool grey);
    void mlfi_header(SMFICTX *ctx, const char *headerf, const char *headerv);
    void mlfi_eoh();
    void mlfi_body(const u_char *bodyp, size_t bodylen);
    void mlfi_eom(bool &grey, int &bulk);

private:
    void my_disconnect();
    void Connect();
    size_t my_write(const char *buf, size_t len);
    size_t my_read(char *buf, size_t len);
    void output(const char *buffer, size_t size);
    void output(const char *buffer);
    void output(string buffer);
    void close_output();
    void input();
    const char *getmacro(SMFICTX *ctx, const char *macro, const char *def);

public:
    bool err;               // socket write error
    bool first_recipient;   // have we not seen any recipients?
    bool first_header;      // have we not seen any headers?

    // connection back to main dnsbl priv structure for logging
    mlfiPriv *priv;
    int      ip4;           // ip4 address of smtp client

    // strings owned by main dnsbl
    const char *helo;       // client helo value
    const char *envfrom;    // envelope from value for this message

    // Process handling variables
    int          dccifd_socket;
    const char  *dccifd_port;
    string       dccifd_output; // to dccifd socket
    string       dccifd_input;  // from dccifd socket
};

#endif
