%define localstatedir   /var/lib

Summary:            Sendmail milter for spam control
Name:               dnsbl
Version:            6.45
Release:            1%{?dist}
License:            GPLv3+
Group:              System Environment/Daemons
Source:             http://www.five-ten-sg.com/%{name}/packages/%{name}-%{version}.tar.gz
BuildRoot:          %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
URL:                http://www.five-ten-sg.com/%{name}/

Requires(pre):          /usr/sbin/useradd
Requires(pre):          /usr/bin/getent
Requires(postun):       /usr/sbin/userdel
Requires(post,preun):   /sbin/chkconfig
Requires(post,preun):   /sbin/service
BuildRequires:          sendmail-devel >= 8.12.1
BuildRequires:          glibc-devel
%if 0%{?fedora} >= 14
BuildRequires:          glibc-static
%endif
%if 0%{?el6}
BuildRequires:          glibc-static
%endif
Requires:               sendmail >= 8.12.1
Requires:               sendmail-cf
Requires:               spamassassin


%description
We present here a mechanism whereby the backup mail server can use the
correct set of DNSBLs for each recipient for each message. As a
side-effect, it gives us the ability to customize the set of DNSBLs on
a per-recipient basis, so that fred@example.com could use LOCAL and
the SBL, where all other users @example.com use only the SBL.

This milter will also decode (base64, mime, html entity, url
encodings) and scan for HTTP and HTTPS URLs and bare hostnames in the
body of the mail. If any of those host names have A or NS records on
the SBL (or a single configurable DNSBL), the mail will be rejected
unless previously whitelisted. This milter also counts the number of
invalid HTML tags, and can reject mail if that count exceeds your
specified limit.

The DNSBL milter reads a text configuration file (dnsbl.conf) on
startup, and whenever the config file (or any of the referenced
include files) is changed. The entire configuration file is case
insensitive.


%prep
%setup -q

%build
%configure
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mv -f $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/%{name} $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/var/run/%{name}
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/autowhite
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/.spamassassin


%pre
/usr/bin/getent passwd %{name} >/dev/null || /usr/sbin/useradd -r -d %{_sysconfdir}/%{name} -M -c "%{name} pseudo-user" -s /sbin/nologin %{name} >/dev/null


%post
/sbin/chkconfig --add %{name}
echo Remember to edit %{_sysconfdir}/%{name}/%{name}.conf and add the following line to your sendmail.mc:
echo "INPUT_MAIL_FILTER(\`dnsbl', \`S=local:/var/run/dnsbl/dnsbl.sock, F=T, T=C:30s;S:5m;R:5m;E:5m')"
echo


%preun
[ $1 = 0 ] && /sbin/service %{name} stop    || :
[ $1 = 0 ] && /sbin/chkconfig --del %{name} || :


%postun
[ $1 = 0 ] && userdel %{name} || :


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%{_sbindir}/*
%{_mandir}/man1/*
%{_mandir}/man5/*
%docdir %{_datadir}/doc/%{name}-%{version}
%{_datadir}/doc/%{name}-%{version}
%config(noreplace) %attr(0750,%{name},root) %{_sysconfdir}/%{name}
/etc/rc.d/init.d/%{name}
%dir %attr(0750,%{name},root) /var/run/%{name}


%changelog
* Thu Apr 09 2015 Carl Byington <carl@five-ten-sg.com> - 6.45-1
- Add bitcoin donation address

* Mon Oct 13 2014 Carl Byington <carl@five-ten-sg.com> - 6.44-1
- Generic regex now matches against the reverse dns PTR value

* Fri Jul 18 2014 Carl Byington <carl@five-ten-sg.com> - 6.43-1
- Allow broken SRS0+ rather than the correct SRS0= tag.

* Sat Jun 28 2014 Carl Byington <carl@five-ten-sg.com> - 6.42-1
- Never add auto-whitelist entries for outgoing mail from localhost.

* Fri Mar 21 2014 Carl Byington <carl@five-ten-sg.com> - 6.41-1
- Unique ip connection limits only apply to authenticated connections.

* Wed Feb 05 2014 Carl Byington <carl@five-ten-sg.com> - 6.40-1
- Fix possible segfault in mlfi_connect, hostaddr might be null.

* Tue Dec 31 2013 Carl Byington <carl@five-ten-sg.com> - 6.39-1
- Fix segfault caused by freeing unallocated memory.

* Tue Dec 24 2013 Carl Byington <carl@five-ten-sg.com> - 6.38-1
- Activate check for unique ip connection limits.

* Tue Dec 17 2013 Carl Byington <carl@five-ten-sg.com> - 6.37-1
- Add unique ip connection limits per authenticated id or email address.

* Mon Sep 09 2013 Carl Byington <carl@five-ten-sg.com> - 6.36-1
- Code cleanup, increase minimum hostname length for uribl checking.

* Mon Sep 09 2013 Carl Byington <carl@five-ten-sg.com> - 6.35-1
- Use mozilla prefix list for tld checking. Enable surbl/uribl/dbl
  rhs lists.

* Wed May 22 2013 Carl Byington <carl@five-ten-sg.com> - 6.34-1
- Add require_rdns checking.

* Sat Jul 21 2012 Carl Byington <carl@five-ten-sg.com> - 6.33-1
- Fix unauthenticated rate limit bug for empty mail from.
  Move unauthenticated rate limit checks after spam filtering.

* Sat Jul 21 2012 Carl Byington <carl@five-ten-sg.com> - 6.32-1
- Allow rate limiting for unauthentication connections by mail
  from address or domain.

* Sun Jul 01 2012 Carl Byington <carl@five-ten-sg.com> - 6.31-1
- Fix uribl lookups on client dns name, need to strip the ip
  address in brackets.

* Mon Apr 09 2012 Carl Byington <carl@five-ten-sg.com> - 6.30-1
- Allow dnswl_list and dnsbl_list to be empty, to override lists
  specified in the ancestor contexts.
- Add daily recipient limits as a multiple of the hourly limits.

* Sun Apr 08 2012 Carl Byington <carl@five-ten-sg.com> - 6.29-1
- Add dnswl support.

* Fri Sep 30 2011 Carl Byington <carl@five-ten-sg.com> - 6.28-1
- Add prvs decoding to envelope addresses.

* Mon Aug 15 2011 Carl Byington <carl@five-ten-sg.com> - 6.27-1
- const correctness fixes from new gcc

* Fri Nov 19 2010 Carl Byington <carl@five-ten-sg.com> - 6.26-1
- 64bit fixes for libresolv.a

* Thu Jul 22 2010 Carl Byington <carl@five-ten-sg.com> - 6.25-2
- chkconfig -del in %%preun, not %%postun

* Tue Sep 29 2009 Carl Byington <carl@five-ten-sg.com> - 6.25-1
- Add surbl checks on the smtp helo value, client reverse dns name,
  and mail from domain name.

* Tue Jun 09 2009 Carl Byington <carl@five-ten-sg.com> - 6.24-1
- Add SRS decoding to envelope addresses.

* Mon May 25 2009 Carl Byington <carl@five-ten-sg.com> - 6.23-1
- Add whitelisting by regex expression filtering.

* Fri May 08 2009 Carl Byington <carl@five-ten-sg.com> - 6.22-1
- Prevent auto whitelisting due to outgoing multipart/report
  delivery notifications.
- Fix memory leak in suppressed auto whitelisting.

* Sat Jan 03 2009 Carl Byington <carl@five-ten-sg.com> - 6.21-1
- Fixes to compile on old systems without memrchr or string::clear().
- Fix bug in spamassassin interface trying to clear a string with string::empty().

* Sat Dec 27 2008 Carl Byington <carl@five-ten-sg.com> - 6.20-1
- Never whitelist self addressed mail.
- Fixes to compile on Fedora 10 and for const correctness.

* Tue Jun 10 2008 Carl Byington <carl@five-ten-sg.com> - 6.19-1
- Fixes to compile on Fedora 9 and for const correctness.

* Wed Mar 05 2008 Carl Byington <carl@five-ten-sg.com> - 6.18-1
- Extend auto-whitelisting when receiving mail even if the auto
  whitelist is specified in a parent context.

* Tue Mar 04 2008 Carl Byington <carl@five-ten-sg.com> - 6.17-1
- changes for Fedora packaging guidelines

* Thu Aug 30 2007 Carl Byington <carl@five-ten-sg.com> - 6.07
- Add generic rdns filtering, fix pre/post scripts

* Sun Aug 26 2007 Carl Byington <carl@five-ten-sg.com> - 6.04
- require spamassassin

* Sat Jul 07 2007 Carl Byington <carl@five-ten-sg.com> - 6.01
- GPL3, auto whitelisting

* Wed Aug 02 2006 Carl Byington <carl@five-ten-sg.com> - 5.20
- http://www.rpm.org/max-rpm/s1-rpm-inside-scripts.html help with postun

* Thu Mar 16 2006 Carl Byington <carl@five-ten-sg.com> - 5.16
- use %{name} in more places

* Fri Mar 10 2006 Carl Byington <carl@five-ten-sg.com> - 5.13
- remove redundant entry in files section

* Sun Dec 18 2005 Carl Byington <carl@five-ten-sg.com> - 5.11
- use autoconf and http://www.fedora.us/docs/rpm-packaging-guidelines.html

* Tue Jan 03 2005 Carl Byington <carl@five-ten-sg.com> - 4.0
- added hosts-ignore conf file
- see RELEASE_NOTES

* Thu Jul 15 2004 John Gunkel <antispam@boing.ca> - 1.3
- patch to rc file no longer needed
- see RELEASE_NOTES

* Mon Jul 05 2004 John Gunkel <jgunkel@palliser.ca> - 1.2
- Fixed some typos
- removed patch into separate file
- added config migration as suggested by Carl
- Added reminder to edit sendmail.mc

* Wed Jun 30 2004 John Gunkel <jgunkel@palliser.ca> - 1.1
- Initial revision of spec file. Need to add a better description, docs and a sendmail.mc message
