require 'tofu/tofulet'
require 'drb/drb'

def setup_bartender(monolithic=true)
  if monolithic
    require 'yourapp'
    Tofu::Bartender.new(YourTofuSession)
  else
    DRbObject.new(nil, 'druby://localhost:7642')
  end
end


def main(monolithic=true)
  DRb.start_service

  logger = WEBrick::Log::new($stderr, WEBrick::Log::DEBUG)

  port = ARGV.shift || "2000"

  s = WEBrick::HTTPServer.new(:Port => port.to_i,
			      :AddressFamily => Socket::AF_INET,
			      :BindAddress => ENV['HOSTNAME'],
			      :Logger => logger)

  bartender = setup_bartender(monolithic)
  s.mount("/div", WEBrick::Tofulet, bartender)

  trap("INT"){ s.shutdown }
  s.start
end

main

