require 'div'
require 'hako'

class HakoDiv < Div::Div
  set_erb('hako.erb')

  def initialize(session)
    super(session)
    start
    @show = false
  end
  attr_reader :count
  attr_accessor :show

  def start
    @widget = Hako::TableHako.new(self)
    @game = Hako::Game.new(@widget)
    @count = 0
  end

  def finish?
    @game.finish?
  end

  def to_args(params)
    chip, = params['chip']
    dx, = params['dx']
    dy, = params['dy']

    chip = chip.to_i if chip
    dx = dx.to_i if dx
    dy = dy.to_i if dy 

    return chip, dx, dy
  end

  def do_move(context, params)
    chip, dx, dy = to_args(params) rescue return
    @count += 1
    @widget.do_move(chip, dx, dy)
  end

  def do_hide(context, params)
    @show = false
  end

  def do_show(context, params)
    @show = true
  end
  
  def do_retry(context, params)
    start
  end

  public :a
end

