require 'div'
require 'parsedate'

class ReminderDiv < Div::Div
  set_erb('reminder.erb')

  def initialize(session, reminder)
    super(session)
    @reminder = reminder
    @mode = :browse
  end

  def remove(key)
    @reminder.remove(session.username, key)
  end

  def add(text, time)
    @reminder.add(text, session.username, time)
  end

  def to_args(params)
    key, = params['key']
    text, = params['text']
    time, = params['time']
    time = Time.local(*(ParseDate.parsedate(time)[0,6])) if time
    return key, text, time
  end

  def do_remove(context, params)
    key, = to_args(params)
    remove(key)
  end

  def do_edit(context, params)
    @mode = :edit
  end
  
  def do_browse(context, params)
    @mode = :browse
  end

  def do_set(context, params)
    key, text, time = to_args(params)
    remove(key)
    add(text, time)
    @mode = :browse
  end

  def do_add(context, params)
    key, text, time = to_args(params)
    add(text, time)
    @mode = :browse
  end
end

