require 'thread'
require 'md5'
require 'pstore'
require 'singleton'

class MBox
  include Singleton

  class Item
    def initialize(text, from, owner)
      @text = text
      @from = from
      @owner = owner
      @time = Time.now
      md5 = MD5.new([text, from, owner].inspect)
      @key =  md5.hexdigest[0,16]
    end
    attr_reader :key
    attr_accessor :text, :owner, :from, :time

    def <=>(obj)
      @time <=> obj.time
    end

    def to_hash
      {'key'=>@key, 'owner'=>@owner, 'time'=>@time, 
	'text'=>@text, 'from'=>@from}
    end
  end

  def initialize
    @mutex = Mutex.new
    @item = []
    @pstore = PStore.new('mbox.db')
    load
  end
  attr_reader :item

  def list(who)
    @mutex.synchronize do
      @item.find_all do |item|
	item.owner == who
      end
    end
  end

  def fetch_hash(who)
    ary = list(who)
    ary.collect do |item|
      item.to_hash
    end
  end

  def add(text, from, to)
    @mutex.synchronize do
      @item.push(Item.new(text, from, to))
      @item.sort!
    end
    save
  end

  def remove(who, key)
    @mutex.synchronize do
      @item.delete_if do |item|
	item.owner == who and item.key == key
      end
    end
    save
  end

  def load
    @mutex.synchronize do
      @pstore.transaction do |db|
	db['item'] = [] unless db.root?('item')
	@item = db['item']
      end
      @item = [] unless @item
    end
  end

  def save
    @mutex.synchronize do
      @pstore.transaction do |db|
	db['item'] = @item
	db.commit
      end
    end
  end
end

if __FILE__ == $0
  require 'drb/drb'

  front = MBox.instance
  DRb.start_service(ARGV.shift || 'druby://localhost:7983', front)
  puts DRb.uri
  gets
end
