#!/usr/local/bin/perl
# $Id: mirror.pl,v 1.6 1994/07/27 18:51:51 ww0r Exp $
#
# (c) 1994 Carnegie Mellon University
#
# This program creates a depot v5 environment from a depot v4
# environment. 
# 
# argv[0] should point to the depot directory of the depot v4 env
# argv[1] should point to the depot directory of the depot v5 env
#         this directory must already exist
#
# NOTE: Don't forget to convert your custom.depot[.proto]. That can be
#       done with custom.depot2depot.pref found in this source directory.
#

require "getopts.pl";

$do_fsi = 1;
&Getopts('I');

$do_fsi = 0
  if ($opt_I);

$| = 1;

die "usage: mirror remote_directory local_directory\n"
  if (@ARGV != 2);

$mdir = $ARGV[0];
$ldir = $ARGV[1];
$image_dir = "$ldir/depot-images";

die "Invalid directory to mirror: $mdir\n"
  if (! -d $mdir);

die "Invalid directory to mirror: $ldir\n"
  if (! -d $ldir);

# get entries in the directory

print "Scanning remote directory: $mdir...";
opendir(FD, $mdir) || die "Can't open directory: $mdir\n";
@mdirs = grep(!/\.\.?$/, grep(-d "$mdir/$_", 
			      readdir(FD)));
close(FD);
print "Found " . @mdirs . " entries.\n";

print "Scanning local directory: $ldir...";
opendir(FD, $ldir) || die "Can't open directory: $ldir\n";
@ldirs =grep (!/\.\.?$/, 
	      grep (((-l "$ldir/$_") || (-d "$ldir/$_")), readdir(FD)));
close(FD);
print "Found " . @ldirs . " entries.\n";

print "Updating local dir\n";
# Get the changes in the local directory
%mark = ();
grep($mark{$_}++, @mdirs);
@new = grep(!$mark{$_}, @ldirs);
print "Removing " . @new . " out of date files....";
$newline = 1;
foreach (@new) {
  if (-d "$ldir/$_") {
    print "skipping directory $_\n";
    next;
  }
  print "$_..." ;
  unlink("$ldir/$_") || 
    die "Unable to complete remove: $!\n";
  if ($newline++ > 5) {
    print "\n\t";
    $newline = 0;
  }
}
print "done.\n";

# update the info from the remote dir
%coll = ();
%mark = ();
grep($mark{$_}++, @ldirs);
@new = grep(!$mark{$_}, @mdirs);
print "Adding " . @new . " new collections...\n";
foreach (@new) {
    
  print "symlink $mdir/$_ $ldir/$_\n";
  symlink("$mdir/$_", "$ldir/$_") || 
    die "Unable to symlink: $!\n";
  ($name, $ver) = split(/\./, $_);
  if ($ver) {
    $coll{$name} = $ver
      if ((!defined $coll{$name}) || ($ver > $coll{$name}));
  } else {
    $coll{$name} = -1;
  }
}
print "done.\n";

if ($do_fsi) {
# generate the images
  if (! -d "$image_dir") {
    print "mkdir $image_dir";
    mkdir ("$image_dir", 0777) ||
      die " $!\n";
    print "\n";
  }

  $newline = 2;
  print "Generating the image and setting the hints...";
  foreach $i (sort keys %coll) {
    print "$i...";
    if ($coll{$i} == -1) {
      $c_dir = "$mdir/$i";
    } else  {
      $c_dir = "$mdir/$i.$coll{$i}";
    }

    # make the fsi_image
    `fsi_generate $c_dir > $image_dir/$i.image`;
    if ($? != 0) {
      print STDERR "Error generating fsi_images: $!\n";
      unlink($image_dir/$coll{$i}.image);
      exit(-1);
    }
    ($hintpath) = reverse split(/\//, $c_dir);
    `hintservice -set $ldir/depot.hint -image $image_dir/$i.image $hintpath`;
    if ($? != 0) {
      print STDERR "Error setting hints: $!\n";
      exit(-1);
    }
  }				# 
  if ($newline++ > 5) {
    print "\n\t";
    $newline = 0;
  }
  print "done.\n";    
}

exit(0);

sub
get_dirs {
  local($dir) = @_;
  local(@dirs);
  local(*FD);

  opendir(FD, $dir) || die "Can't open directory: $dir\n";
  
  @dirs = grep(!/\.\.?$/, grep(-d "$dir/$_", 
			       readdir(FD)));
  close(FD);
 
 return @dirs;
}

# $Source: /afs/andrew.cmu.edu/system/src/local/depot2/021/tools/conv_tools/RCS/mirror.pl,v $
