#!/usr/local/bin/perl
#
# $Id: list-ver.pl,v 1.1 1994/07/06 18:18:40 ww0r Exp $
# 
# list the higest versions of the collections in a given directory
# 
# usage: dir [delim]
#


$dir = $ARGV[0];
if ($ARGV[1]) {
  $delim = $ARGV[1];
  chop($delim);			# ditch \n
} else {
  $delim = '.';
}


die "Invalid directory $dir\n"
  if (! -d "$dir");

opendir(DP, "$dir") 
  || die "Can't open directory: $dir: $!\n";

@items = grep (!/^\.\.?$/, 
	       grep (-d "$dir/$_" , readdir(DP)));
closedir(DP);

$char = "\\" . $delim;
foreach (@items) {
  ($name, $ver) = split(/$char/);
  $ver = -1
    if (!defined $ver);
  next
    if ((defined $col{$name}) && ($ver < $col{$name}));
  $col{$name} = $ver;
}

foreach (sort keys %col) {
  if ($col{$_} == -1) {
    print "$_\n";
  } else {
    print "$_$delim$col{$_}\n";
  }
}

# $Source: /afs/andrew.cmu.edu/system/src/local/depot2/021/tools/conv_tools/RCS/list-ver.pl,v $
