#!/usr/local/bin/perl
#$Id: run_delta_test.pl,v 1.7 1995/03/20 20:58:32 ww0r Exp $
#
# This program goes through and mirrors an existing depot2 environment to esnure
# that -Q works right.

$| = 1;

die "usage: run_delta_test.pl env sys\n"
  if (@ARGV != 2);

$env = $ARGV[0];
$sys=$ARGV[1];
$cwd = `pwd`; chop $cwd;
$sun = 0;


die "Not in delta depot directory. Exiting"
  unless ($cwd =~ /\/system\/delta\/.*\/depot$/);

if ($sys eq "sun4_413") {
  $shadow = 1;
  $shadow_remdir = "/afs/andrew.cmu.edu/system/beta/sun4m_413/${env}";
  $shadowdir = "/afs/andrew.cmu.edu/system/delta/sun4m_413/${env}";
  $sun = 1;
} 

if ($sys eq "sun4m_413") {
  $shadow = 0;
  $sun = 1;
}

# make sure we are in the delta directory or there is an override. keep
# from erasing files where we don't wait 'em to be ereased!
print "* Starting delta tests: " . '$Revision: 1.7 $ for '. "env: $env  sys: $sys on " . `date`;

$destdir="/afs/andrew.cmu.edu/system/dest/@sys/local";
$dver=$ENV{"DVER"};
die "Please set DVER to the right version of depot\n"
  if (! $dver);

$ddir="${destdir}/depot2/${dver}";
$depot="$ddir/bin/depot";
$hintservice="$ddir/bin/hintservice";

$dppver=$ENV{"DPPVER"};
die "Please set DDIR to the right version of depot\n"
  if (! $dppver);

$dpp="${destdir}/dpp/${dppver}/bin/dpp";

$depot = $ENV{"DEPOT_PROGRAM"}
  if ($ENV{"DEPOT_PROGRAM"});

$dpp =$ENV{"DPP_PROGRAM"}
  if ($ENV{"DPP_PROGRAM"});

$hintservice = $ENV{"HINTSERVICE_PROGRAM"}
  if ($ENV{"HINTSERVICE_PROGRAM"});

$remdir="/afs/andrew.cmu.edu/system/beta/${sys}/${env}";
$depotdir="$remdir/depot";

print "depot: $depot\tdpp:$dpp\n";
print "hintservice: $hintservice\n";

foreach (sort grep(-d "$depotdir/$_", grep(!/^\.\.?$/, &list("$depotdir")))) {
#extract x11config out of the list. Make sure it is processed first
  next
    if (($sun) && ((/^sun4c_411$/) || (/^sun4_413$/)));

  if (/^x11config/) {
    push(@process, $_);	# sort should put these in the right order. 
  } else {
    push(@rest, $_);
  }
}

foreach (@rest) {
  ($name, $ver) = split(/\./);	# add things chronologically
  if (defined $ver) {		# versions have to be unique per environment. as two
    next if ($ver < 0); 	# collections couldn't have been released at the same time
    $coll{$ver} = $_;	
  } else {
    push(@process, $_);
  }
}

foreach (sort keys %coll) {
  push(@process, "$coll{$_}");
}

print "** Will process " . @process . " collections: "; 
$wrap = 4; $i = $wrap/2;
foreach (@process) {
  print "\t"
    if ($i == 1);
  print "$_ ";
  if (++$i > $wrap) {
    print "\n";
    $i = 1;
  }

}
print "\n"
  unless ($i==1);

# ok, let's start to do some real work now
if ($sun) {
  @copyfiles = ("depot.pref.proto", "depot.conf.proto");
} else {
  @copyfiles = ("depot.pref", "depot.conf");
}

&nuke_files(&list("."));
&copy($depotdir, @copyfiles, ".");

if ($shadow) {
  print "* Updating Shadow directory...\n";
  &nuke_files(grep($_ = "$shadowdir/depot/$_", &list("$shadowdir/depot")));
  &copy("$shadow_remdir/depot", @copyfiles, "$shadowdir/depot");
}

print "** Running depot to clean out the environemt and build the initial db\n";
rmdir("filler")
  if (-d "filler");
mkdir("filler",0777) || die "Can't create fillter directory: $!`n";

&run("$dpp -T ..")
  if ($sun);

&run("$depot -T .. -v");
rmdir("filler");
if ($sun && $shadow) {
  if (! -d "$shadowdir/depot/filler") {
    mkdir("$shadowdir/depot/filler", 0777) ||die "Can't create shadow filler directory: $!\n";
  }
  `echo "override kcmd wsadmin" >> depot.pref.proto`; # hack to get things to work
  &run("$dpp -T $shadowdir");
  &run("$depot -T $shadowdir -v");
  rmdir("$shadowdir/depot/filler");
}
  
if ($sun) {
  print "** linking in shadow tree\n";
# warning... there could be problems here if you just wanted to run sun4m 
  if ($sun) {
    if ($sys eq "sun4_413") {
      if (-l "sun4c_411") {
	unlink("sun4c_411") || die "Unable to unlink sun4c_411: $!\n";
      }
      symlink("$depotdir/sun4c_411", 'sun4c_411') || 
	die "Unable to symlink in sun4c_411: $!\n";
    }
    if (-l "$shadowdir/depot/sun4_413") {
      unlink("$shadowdir/depot/sun4_413") || 
	die "Unable to unlink $shadowdir/depot/sun4_413: $!\n";
    }
    symlink("$shadow_remdir/depot/sun4_413", "$shadowdir/depot/sun4_413") || 
      die "Unable to symlink $shadow_remdir/depot/sun4_413->$shadowdir/depot/sun4_413: $!\n";
  }
  print "** running depot to link in shadow area\n";
  &run("$dpp -T ..");
  &run("$depot -T .. -v");
  if ($shadow) {
    &run("$dpp -T $shadowdir");
    &run("$depot -T $shadowdir -v");
  }
}

print "** Starting main run\n";
foreach (@process) {
  print "*** Processing $_...";
  symlink("$depotdir/$_", "$_") ||
    die "Unable to symlink $_: $!\n";
  if (-f "$_/depot.image") {
    print "setting hints.";
    &run("$hintservice -set depot.hint -image $_/depot.image $_");
  }			       
  print "\n";
  &run("$dpp -T ..")
    if ($sun);
  &run("time $depot -T .. -QV");
  if ($sun && $shadow) {
#we should be slick and insert the shadowdir only stuff in at the right place
# but we won't for now. 
    &run("$dpp -T $shadowdir");
    &run("$depot -T $shadowdir -QV");
  }
}
print "**** Collection processing complete \n";
print "*** Running depot -Q again to ensure the next run runs right\n";
&run("$dpp -T ..")
  if ($sun);
&run("time $depot -T .. -Qvn");

if ($sun && $shadow) {
    &run("$dpp -T $shadowdir");
    &run("$depot -T $shadowdir -Qvn");
  }

print "***  Running depot -vn to check for diffs\n";
&run("$dpp -T ..")
  if ($sun);
&run("time $depot -T .. -vn");

if ($sun && $shadow) {
    &run("$dpp -T $shadowdir");
    &run("$depot -T $shadowdir -vn");
  }

print "* All done on " . `date`;

exit(0);


# procedure defs
sub
run {
  $cmd = @_[0];

  print "-- running: $cmd\n";
  system("$cmd");
  die "Error running $cmd: $!\n"
    if ($? != 0);
}

sub
list {
  $dir = @_[0];
  local(@list);
  local(*DP);
  
  opendir(DP, "$dir") || die "Can't open directory: $dir: $!\n";
  @list = readdir(DP);
  closedir(DP);
  @list;
}

sub
nuke_files {
  local(@nuke) = @_;
  
  print "** Removing files:  ";
  foreach (@nuke) {
    if ((-f $_) || (-l $_)) {
      print "$_ ";
      unlink($_) || die "Unable to remove $_: $!\n";
    }
  }
  print "done. \n";
}

sub 
copy {
  local(@copyfiles);
  local($dest);
  local($src);

  $dest = pop (@_);
  $src = shift (@_);
  @copyfiles = @_;

  print "** Copying files from $src to $dest ... ";
  foreach (@copyfiles) {
    if (-f "$src/$_") {
      print "$_ ";
      `cp $src/$_ $dest/$_`;
      die "Failed to copy $src/$_:\n"
	if ($? != 0);
    }
  }
  print "done.\n";
}
  
# $Source: /afs/andrew.cmu.edu/system/src/local/depot2/019/tests/RCS/run_delta_test.pl,v $

