/***********************************************************
        Copyright 1991, 1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/




#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: message.c,v 1.7 1994/09/03 05:21:53 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "Error.h"

int PROGRAM_Verbose;


void Message(va_alist)
va_dcl
{
  va_list ap;
  char *fmt;

  va_start(ap);

  fmt = va_arg(ap, char *);
  (void)vfprintf(stdout, fmt, ap);
  fflush(stdout);
  va_end(ap);

  return;
}


void Filtered_Message(va_alist)
     va_dcl
{
  va_list ap;
  unsigned filter;
  char *fmt;

  va_start(ap);

  filter = va_arg(ap, Boolean);
  if (filter)
    {
      fmt = va_arg(ap, char *);
      (void)vfprintf(stdout, fmt, ap);
      fflush(stdout);
    }
  va_end(ap);
  fflush(stdout);
  return;
}


/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/012/src/lib/util/RCS/message.c,v $ */
