/***********************************************************
        Copyright 1991, 1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: file.c,v 1.12 1994/12/08 15:51:44 ww0r Exp $ ";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "Error.h"



FILE *
efopen(filename, type)
     char *filename, *type;
     /* fopen(3S) with error checking */
{
  FILE *f;

  if ((f = fopen(filename, type)) == NULL) {
    FatalError(E_FOPENFAILED,
	       "could not fopen file (%s, %s): %s\n",
	       filename, type, strerror(errno));
  }
  return (PROGRAM_ErrorNo == E_NULL) ? f : NULL;
}



FILE *
efdopen(fd, type)
     int fd;
     char *type;
  /* fdopen(3S) with error checking */
{
  FILE *f;

  if ((f = fdopen(fd, type)) == NULL) {
    FatalError(E_FDOPENFAILED,
	       "could not fdopen file (%d, %s): %s\n",
	       fd, type, strerror(errno));
  }
  return (PROGRAM_ErrorNo == E_NULL) ? f : NULL;
}


/*
 * unsigned efgetunsigned(fp)
 *      returns an unsigned from the current location
 *      of file given by pointer fp
 */
unsigned int
efgetunsigned(fp)
     FILE *fp;
{
  register int ch;
  unsigned value;

  ch = getc(fp);
  while ((ch == ' ') || (ch == '\n'))
    ch = getc(fp);

  value = 0;
  if (ch == EOF) {
    FatalError(E_FGETUNSIGNEDFAILED,
	       "Premature end of file while reading unsigned.\n");
  } else {
    value = 0;
    while ((PROGRAM_ErrorNo == E_NULL)
	   && (ch >= '0') && (ch <= '9')) {
      value *= 10;
      value += (ch - '0');
      ch = getc(fp);
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? value : 0;
}


/*
 * long efgetlong(fp)
 *      returns a long from the current location
 *      of file given by pointer fp
 */
long
efgetlong(fp)
     FILE *fp;
{
  register int ch;
  long value;
  int sign;

  ch = getc(fp);
  while ((ch == ' ') || (ch == '\n'))
    ch = getc(fp);

  sign = 1;
  if (ch == EOF) {
    FatalError(E_FGETLONGFAILED,
	       "Premature end of file while reading long.\n");
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    /* check if it is a + or - sign */
    if ((ch == '-') || (ch == '+')) {
      if (ch == '-')
	sign = -1;
      else if (ch == '+')
	sign = 1;
      ch = getc(fp);
    }
  }
  value = 0;
  if (ch == EOF) {
    FatalError(E_FGETLONGFAILED,
	       "Premature end of file while reading long.\n");
  }
  while ((PROGRAM_ErrorNo == E_NULL)
	 && (ch >= '0') && (ch <= '9')) {
    value *= 10;
    value += (ch - '0');
    ch = getc(fp);
  }

  value *= sign;
  return (PROGRAM_ErrorNo == E_NULL) ? value : 0;
}



char *
efgetstring(fp, quotechar)
     FILE *fp;
     int quotechar;
{
  register char *cp;
  register int i;
  register int ch;
  char *buffer;
  unsigned buffersize;
  unsigned increment = 100;

  ch = getc(fp);
  while ((ch == ' ') || (ch == '\n'))
    ch = getc(fp);

  if (ch == EOF) {
    FatalError(E_FGETSTRINGFAILED,
	       "Premature end of file while reading string.\n");
  } else {
    buffersize = increment;
    buffer = (char *) emalloc(buffersize * sizeof(char));
    cp = buffer;
    i = 0;
    while ((PROGRAM_ErrorNo == E_NULL)
	   && (ch != EOF) && (ch != ' ') && (ch != '\n')) {
      if (ch == quotechar) {
	ch = getc(fp);
	if (ch == EOF) {
	  FatalError(E_FGETSTRINGFAILED,
		     "Premature end of file while reading string.\n");
	}
      }
      if (PROGRAM_ErrorNo == E_NULL) {
	*cp++ = ch;
	i++;
	ch = getc(fp);
	if (i == buffersize) {	/* get more space for string */
	  buffersize += increment;
	  buffer = (char *) erealloc((void *) buffer,
				     buffersize * sizeof(char));
	}
      }
    }
    if (PROGRAM_ErrorNo == E_NULL)
      *cp = '\0';
  }

  return (PROGRAM_ErrorNo == E_NULL) ? buffer : NULL;
}


/*
 * int fdgetc(fd, pos)
 *      returns the character at offset pos from the beginning
 *      of file given by descriptor fd
 */
int
fdgetc(fd, pos)
     int fd;
     long pos;
{
  char c;			/* buffer of length 1 for reading */
  int rcode;

  if (lseek(fd, (off_t) pos, SEEK_SET) < 0) {
    FatalError(E_LSEEKFAILED,
	       "Lseek failed on fd %d: %s\n", fd, strerror(errno));
    return EOF;
  } else {
    rcode = read(fd, &c, 1);
    if (rcode < 0) {
      FatalError(E_READFAILED,
		 "read failed on fd %d: %s\n", fd, strerror(errno));
      return EOF;
    } else if (rcode == 0)
      return EOF;
    else
      return (int) c;
  }
}


/*
 * int efputs(string, quotechar, stream)
 *      
 */
int
quotedfputs(string, quotechar, fp)
     char *string;
     char quotechar;
     FILE *fp;
{
  register char *str;
  register int retval;

  for (str = string; *str; str++) {
    if ((*str == quotechar) || (*str == '\\')) {
      if ((retval = fputc('\\', fp)) < 0) {
	return retval;
      }
    }
    if ((retval = fputc(*str, fp)) < 0) {
      return retval;
    }
  }
  return 0;
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/017/src/lib/util/RCS/file.c,v $ */
