/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: TargetDB_Prune.c,v 1.4 1994/10/06 15:12:10 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "TargetDB.h"


static TARGETDB *TargetDB_TreePruneCollection();
static TARGETDB *TargetDB_TreePruneTargets();


static TARGETDB *
TargetDB_TreePruneCollection(targetdbp, collectionid)
     TARGETDB *targetdbp;
     int collectionid;
{
  register int i;
  register TARGETDB **fp, **tp;

  TARGETDB *newtargetdbp;

  Boolean FoundCollection, FoundDirectory;
  int nchildren;

  newtargetdbp = targetdbp;

  if (newtargetdbp != NULL) {
    TARGETDB_SourceList(newtargetdbp) =
      SourceList_PruneCollection(TARGETDB_SourceList(newtargetdbp),
				 collectionid,
				 &FoundCollection,
				 &FoundDirectory);
    if ((PROGRAM_ErrorNo == E_NULL) && FoundCollection) {
      if (TARGETDB_SourceList(newtargetdbp) == NULL) {
	TargetDB_Free(newtargetdbp);
	newtargetdbp = NULL;
      } else if (FoundDirectory) {
	/* prune child nodes of newtargetdbp */
	i = 0;
	fp = tp = TARGETDB_Children(newtargetdbp);
	nchildren = TARGETDB_ChildCount(newtargetdbp);
	while ((PROGRAM_ErrorNo == E_NULL)
	       && (i < TARGETDB_ChildCount(newtargetdbp))) {
	  *tp = TargetDB_TreePruneCollection(*fp, collectionid);
	  if (*tp == NULL)
	    nchildren--;
	  else
	    tp++;
	  i++, fp++;
	}
	if ((PROGRAM_ErrorNo == E_NULL)
	    && (nchildren != TARGETDB_ChildCount(newtargetdbp))) {
	  TARGETDB_ChildCount(newtargetdbp) = nchildren;
	  if (TARGETDB_ChildCount(newtargetdbp) == 0) {
	    if (TARGETDB_Children(newtargetdbp) != NULL)
	      free((void *) TARGETDB_Children(newtargetdbp));
	    TARGETDB_Children(newtargetdbp) = NULL;
	  } else {
	    TARGETDB_Children(newtargetdbp) =
	      (TARGETDB **)
	      erealloc((void *) TARGETDB_Children(newtargetdbp),
		       TARGETDB_ChildCount(newtargetdbp)
		       * sizeof(TARGETDB *));
	  }
	}
      }
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}



static TARGETDB *
TargetDB_TreePruneTargets(targetdbp)
     TARGETDB *targetdbp;
{
  register int i;
  register TARGETDB **fp, **tp;

  TARGETDB *newtargetdbp;

  int nchildren;

  newtargetdbp = targetdbp;

  if (newtargetdbp != NULL) {
    if (TARGETDB_SourceList(newtargetdbp) == NULL) {
      TargetDB_Free(newtargetdbp);
      newtargetdbp = NULL;
    } else if (TARGETDB_ChildCount(newtargetdbp) > 0) {
      /* prune child nodes of newtargetdbp */
      i = 0;
      fp = tp = TARGETDB_Children(newtargetdbp);
      nchildren = TARGETDB_ChildCount(newtargetdbp);
      while ((PROGRAM_ErrorNo == E_NULL)
	     && (i < TARGETDB_ChildCount(newtargetdbp))) {
	*tp = TargetDB_TreePruneTargets(*fp);
	if (*tp == NULL)
	  nchildren--;
	else
	  tp++;
	i++, fp++;
      }
      if ((PROGRAM_ErrorNo == E_NULL)
	  && (nchildren != TARGETDB_ChildCount(newtargetdbp))) {
	TARGETDB_ChildCount(newtargetdbp) = nchildren;
	if (TARGETDB_ChildCount(newtargetdbp) == 0) {
	  if (TARGETDB_Children(newtargetdbp) != NULL)
	    free((void *) TARGETDB_Children(newtargetdbp));
	  TARGETDB_Children(newtargetdbp) = NULL;
	} else {
	  TARGETDB_Children(newtargetdbp) =
	    (TARGETDB **)
	    erealloc((void *) TARGETDB_Children(newtargetdbp),
		     TARGETDB_ChildCount(newtargetdbp)
		     * sizeof(TARGETDB *));
	}
      }
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}



TARGETDB *
TargetDB_PruneCollection(targetdbp, collectionid)
     TARGETDB *targetdbp;
     int collectionid;
{
  TARGETDB *newtargetdbp;

  newtargetdbp = TargetDB_TreePruneCollection(targetdbp, collectionid);

  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}



TARGETDB *
TargetDB_PruneTargets(targetdbp)
     TARGETDB *targetdbp;
{
  TARGETDB *newtargetdbp;

  newtargetdbp = TargetDB_TreePruneTargets(targetdbp);

  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}

/* $Source: /afs/andrew/system/src/local/depot2/013/src/lib/TargetDB/RCS/TargetDB_Prune.c,v $ */
