/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: SourceList_Prune.c,v 1.5 1994/10/06 18:09:51 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "TargetDB.h"



TARGETSOURCELIST *
SourceList_PruneCollection(sourcelistp,
			   collectionid,
			   FoundCollection,
			   FoundDirectory)
     TARGETSOURCELIST *sourcelistp;
     int collectionid;
     Boolean *FoundCollection, *FoundDirectory;
{
  register unsigned int i1, i2;

  TARGETSOURCELIST *newsourcelistp;

  int nsources;
  int collectionindex;
  Boolean PastCollection;
  TARGETSOURCE *sourcep;
  Boolean Pruned = FALSE;
  
  newsourcelistp = sourcelistp;

  *FoundCollection = FALSE;
  *FoundDirectory = FALSE;
  if (newsourcelistp != NULL) {
    collectionindex = SourceList_FindIndexToCollectionId(newsourcelistp,
							 collectionid,
							 TDB_LAX);
    if (collectionindex >= 0) {
      *FoundCollection = TRUE;
    } else {
      *FoundCollection = FALSE;
    }

    if ((PROGRAM_ErrorNo == E_NULL) && *FoundCollection) {
      i1 = i2 = collectionindex;
      PastCollection = FALSE;
      nsources = TARGETSOURCELIST_NSources(newsourcelistp);
      while ((PROGRAM_ErrorNo == E_NULL)
	     && (i1 < TARGETSOURCELIST_NSources(newsourcelistp))) {
	sourcep = TARGETSOURCELIST_Source(newsourcelistp, i1);
	if (!PastCollection) {
	  if (TARGETSOURCE_CollectionId(sourcep) != collectionid) {
	    PastCollection = TRUE;
	  } else if (TARGETSOURCE_UpdateSpec(sourcep) & U_MKDIR) {
	    *FoundDirectory = TRUE;
	  }
	}
	if (!PastCollection
	    && (TARGETSOURCE_Status(sourcep) & S_OBSOLETE)) {	/* source to
								 * be pruned */
	  TargetSource_Free(sourcep);
	  TARGETSOURCELIST_Source(newsourcelistp, i1) = NULL;
	  nsources--;
	  Pruned =  TRUE;
	} else {
	  if (i1 != i2) {
	    TARGETSOURCELIST_Source(newsourcelistp, i2) =
	      TARGETSOURCELIST_Source(newsourcelistp, i1);
	    TARGETSOURCELIST_Source(newsourcelistp, i1) = NULL;
	  }
	  i2++;
	}
	i1++;
      }
      if ((PROGRAM_ErrorNo == E_NULL) && Pruned) {
	for (i1 = 0; i1 < nsources; i1++) {
	  TARGETSOURCE_UpdateSpec(TARGETSOURCELIST_Source(newsourcelistp, i1)) &=~U_TARGET;
	}
      }
      if ((PROGRAM_ErrorNo == E_NULL)
	  && (nsources != TARGETSOURCELIST_NSources(newsourcelistp))) {
	TARGETSOURCELIST_NSources(newsourcelistp) = nsources;
	if (TARGETSOURCELIST_NSources(newsourcelistp) == 0) {
	  free((void *) TARGETSOURCELIST_SourceArray(newsourcelistp));
	  free((void *) newsourcelistp);
	  newsourcelistp = NULL;
	} else {
	  TARGETSOURCELIST_SourceArray(newsourcelistp) =
	    (TARGETSOURCE **)
	    erealloc((void *) TARGETSOURCELIST_SourceArray(newsourcelistp),
		     TARGETSOURCELIST_NSources(newsourcelistp)
		     * sizeof(TARGETSOURCE *));
	}
      }
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newsourcelistp : NULL;
}

/* $Source: /afs/andrew/system/src/local/depot2/013/src/lib/TargetDB/RCS/SourceList_Prune.c,v $ */
