/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: Preference_Diff.c,v 1.3 1994/08/12 22:12:40 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Preference.h"


static Boolean PreferenceValue_Equality();
static PREFERENCE ***PreferenceDiffArray_Append();



static Boolean PreferenceValue_Equality(p1, p2)
     PREFERENCE *p1, *p2;
{
  Boolean EqualValues;
  unsigned short preftype;

  EqualValues = TRUE;
  if ((p1 == NULL) || (p2 == NULL))
    {
      FatalError(E_NULLPREFERENCE,
		 "Attempt to check value of NULL preference.\n");
    }

  if (PROGRAM_ErrorNo == E_NULL)
    {
      if (PREFERENCE_Type(p1) != PREFERENCE_Type(p2))
	EqualValues = FALSE;
      else
	{
	  preftype = PREFERENCE_Type(p1);
	  if (preftype & PREF_INTEGER)
	    {
	      if (PREFERENCE_IVal(p1) == PREFERENCE_IVal(p2))
		EqualValues = TRUE;
	      else
		EqualValues = FALSE;
	    }
	  else if (preftype & PREF_UNSIGNED)
	    {
	      if (PREFERENCE_UVal(p1) == PREFERENCE_UVal(p2))
		EqualValues = TRUE;
	      else
		EqualValues = FALSE;
	    }
	  else if (preftype & PREF_BOOLEAN)
	    {
	      if (PREFERENCE_BoolVal(p1) == PREFERENCE_BoolVal(p2))
		EqualValues = TRUE;
	      else
		EqualValues = FALSE;
	    }
	  else if (preftype & PREF_STRING)
	    {
	      if (String_Comparator(PREFERENCE_StrVal(p1),
				    PREFERENCE_StrVal(p2)) == 0)
		EqualValues = TRUE;
	      else
		EqualValues = FALSE;
	    }
	  else if (preftype & PREF_STRINGARRAY)
	    {
	      if (StringArray_Comparator(PREFERENCE_StrArrVal(p1),
					 PREFERENCE_StrArrVal(p2)) == 0)
		EqualValues = TRUE;
	      else
		EqualValues = FALSE;
	    }
	  else if (preftype & PREF_STRINGSET)
	    {
	      if (StringArray_Comparator(PREFERENCE_StrSetVal(p1),
					 PREFERENCE_StrSetVal(p2)) == 0)
		EqualValues = TRUE;
	      else
		EqualValues = FALSE;
	    }
	  else if (preftype & PREF_SENTENCE)
	    {
	      if (StringArray_Comparator(PREFERENCE_SentenceVal(p1),
					 PREFERENCE_SentenceVal(p2)) == 0)
		EqualValues = TRUE;
	      else
		EqualValues = FALSE;
	    }
	  else
	    {
	      FatalError(E_BADPREFTYPE,
			 "Unknown value type %x in preference database.\n",
			 preftype);
	    }
	}
    }
      
  return (PROGRAM_ErrorNo == E_NULL) ? EqualValues : FALSE;
}


static PREFERENCE ***PreferenceDiffArray_Append(diffarray, pref1, pref2)
     PREFERENCE ***diffarray;
     PREFERENCE *pref1, *pref2;
{
  PREFERENCE **pp1, **pp2;
  PREFERENCE ***prefpairp;
  PREFERENCE ***newdiffarray;
  unsigned short preftype;
  int ArraySize;

  newdiffarray = diffarray;
  if (newdiffarray == NULL)
    { /* allocate array of length 1 */
      newdiffarray = (PREFERENCE ***)emalloc(sizeof(PREFERENCE **));
      if (PROGRAM_ErrorNo == E_NULL) *newdiffarray = NULL;
    }

  if (PROGRAM_ErrorNo == E_NULL)
    {
      prefpairp = newdiffarray;
      while (*prefpairp != NULL) prefpairp++;
      ArraySize = prefpairp - newdiffarray + 1;
      ArraySize++;
      newdiffarray
	= (PREFERENCE ***)erealloc((char *)newdiffarray,
				  (unsigned)ArraySize*sizeof(PREFERENCE **));
    }

  if (PROGRAM_ErrorNo == E_NULL)
    {
      prefpairp = newdiffarray + ArraySize - 2;
      *(prefpairp+1) = NULL;
      *prefpairp = (PREFERENCE **)emalloc(2*sizeof(PREFERENCE *));
    }

  if (PROGRAM_ErrorNo == E_NULL)
    {
      pp1 = *prefpairp; pp2 = pp1+1;
      if (pref1 == NULL)
	*pp1 = NULL;
      else
	*pp1 = (PREFERENCE *)emalloc(sizeof(PREFERENCE));
      if (*pp1 != NULL)
	{
	  PREFERENCE_OptionID(*pp1) = PREFERENCE_OptionID(pref1);
	  PREFERENCE_Type(*pp1) = PREFERENCE_Type(pref1);
	  PREFERENCE_Operand(*pp1)
	    = (PREFERENCE_Operand(pref1) == NULL ) ? NULL :
	      String(PREFERENCE_Operand(pref1),
		     strlen(PREFERENCE_Operand(pref1)));
	}
      if (pref2 == NULL)
	*pp2 = NULL;
      else
	*pp2 = (PREFERENCE *)emalloc(sizeof(PREFERENCE));
      if (*pp2 != NULL)
	{
	  PREFERENCE_OptionID(*pp2) = PREFERENCE_OptionID(pref2);
	  PREFERENCE_Type(*pp2) = PREFERENCE_Type(pref2);
	  PREFERENCE_Operand(*pp2)
	    = (PREFERENCE_Operand(pref2) == NULL ) ? NULL :
	      String(PREFERENCE_Operand(pref2),
		     strlen(PREFERENCE_Operand(pref2)));
	}
    }

  if ((PROGRAM_ErrorNo == E_NULL) && (pref1 != NULL))
    {
      preftype = PREFERENCE_Type(*pp1);
      if (preftype & PREF_INTEGER)
	{
	   PREFERENCE_IVal(*pp1) = PREFERENCE_IVal(pref1);
	}
      else if (preftype & PREF_UNSIGNED)
	{
	  PREFERENCE_UVal(*pp1) = PREFERENCE_UVal(pref1);
	}
      else if (preftype & PREF_BOOLEAN)
	{
	  PREFERENCE_BoolVal(*pp1) = PREFERENCE_BoolVal(pref1);
	}
      else if (preftype & PREF_STRING)
	{
	  PREFERENCE_StrVal(*pp1) = String(PREFERENCE_StrVal(pref1),
					  strlen(PREFERENCE_StrVal(pref1)));
	}
      else if (preftype & PREF_STRINGARRAY)
	{
	  PREFERENCE_StrArrVal(*pp1)
	    = StringArray(PREFERENCE_StrArrVal(pref1),
			  StringArray_Size(PREFERENCE_StrArrVal(pref1)));
	}
      else if (preftype & PREF_STRINGSET)
	{
	  PREFERENCE_StrSetVal(*pp1)
	    = StringArray(PREFERENCE_StrSetVal(pref1),
			  StringArray_Size(PREFERENCE_StrSetVal(pref1)));
	}
      else if (preftype & PREF_SENTENCE)
	{
	  PREFERENCE_SentenceVal(*pp1)
	    = StringArray(PREFERENCE_SentenceVal(pref1),
			  StringArray_Size(PREFERENCE_SentenceVal(pref1)));
	}
      else
	{
	  FatalError(E_BADPREFTYPE,
		     "Unknown value type %x in preference database.\n",
		     preftype);
	}
    }

  if ((PROGRAM_ErrorNo == E_NULL) && (pref2 != NULL))
    {
      preftype = PREFERENCE_Type(*pp2);
      if (preftype & PREF_INTEGER)
	{
	  PREFERENCE_IVal(*pp2) = PREFERENCE_IVal(pref2);
	}
      else if (preftype & PREF_UNSIGNED)
	{
	  PREFERENCE_UVal(*pp2) = PREFERENCE_UVal(pref2);
	}
      else if (preftype & PREF_BOOLEAN)
	{
	  PREFERENCE_BoolVal(*pp2) = PREFERENCE_BoolVal(pref2);
	}
      else if (preftype & PREF_STRING)
	{
	  PREFERENCE_StrVal(*pp2) = String(PREFERENCE_StrVal(pref2),
					  strlen(PREFERENCE_StrVal(pref2)));
	}
      else if (preftype & PREF_STRINGARRAY)
	{
	  PREFERENCE_StrArrVal(*pp2)
	    = StringArray(PREFERENCE_StrArrVal(pref2),
			  StringArray_Size(PREFERENCE_StrArrVal(pref2)));
	}
      else if (preftype & PREF_STRINGSET)
	{
	  PREFERENCE_StrSetVal(*pp2)
	    = StringArray(PREFERENCE_StrSetVal(pref2),
			  StringArray_Size(PREFERENCE_StrSetVal(pref2)));
	}
      else if (preftype & PREF_SENTENCE)
	{
	  PREFERENCE_SentenceVal(*pp2)
	    = StringArray(PREFERENCE_SentenceVal(pref2),
			  StringArray_Size(PREFERENCE_SentenceVal(pref2)));
	}
      else
	{
	  FatalError(E_BADPREFTYPE,
		     "Unknown value type %x in preference database.\n",
		     preftype);
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? newdiffarray : NULL;
}



PREFERENCE ***Preference_Diff(prefdb1, prefdb2)
     PREFERENCEDB *prefdb1, *prefdb2;
{
  register unsigned i;
  register PREFERENCE ***arrayp;
  register PREFERENCE **pp;
  PREFERENCE *pref1, *pref2;
  PREFERENCE ***diffarray;
  char *item, *name;

  if ((prefdb1 == NULL) || (prefdb2 == NULL))
    {
       FatalError(E_BADPREFERENCEDB,
		  "Attempt to diff with NULL preference database\n");
    }

  diffarray = NULL;
  for (i = 0, arrayp = *prefdb1;
       (PROGRAM_ErrorNo == E_NULL) && (i < Preference_HashTableSize);
       i++, arrayp++)
    {
      if (arrayp == NULL)
	{
	  FatalError(E_BADPREFERENCEDB,
		     "Error navigating hash table of preference database.\n");
	}
      if ((PROGRAM_ErrorNo == E_NULL) && (*arrayp != NULL))
	{
	  for (pp = *arrayp;
	       (PROGRAM_ErrorNo == E_NULL) && (*pp != NULL);
	       pp++)
	    {
	      item = PREFERENCE_Operand(*pp);
	      name = Preference_OptionName(PREFERENCE_OptionID(*pp));
	      pref2 = Preference_Lookup(prefdb2, item, name, FALSE/* Create */);
	      if ((PROGRAM_ErrorNo == E_NULL)
		  && ((pref2 == NULL)
		      || (PreferenceValue_Equality(*pp, pref2) == FALSE)))
		{
		  diffarray = PreferenceDiffArray_Append(diffarray, *pp, pref2);
		}
	    }
	}
    }

  for (i = 0, arrayp = *prefdb2;
       (PROGRAM_ErrorNo == E_NULL) && (i < Preference_HashTableSize);
       i++, arrayp++)
    {
      if (arrayp == NULL)
	{
	  FatalError(E_BADPREFERENCEDB,
		     "Error navigating hash table of preference database.\n");
	}
      if ((PROGRAM_ErrorNo == E_NULL) && (*arrayp != NULL))
	{
	  for (pp = *arrayp;
	       (PROGRAM_ErrorNo == E_NULL) && (*pp != NULL);
	       pp++)
	    {
	      item = PREFERENCE_Operand(*pp);
	      name = Preference_OptionName(PREFERENCE_OptionID(*pp));
	      pref1 = Preference_Lookup(prefdb1, item, name, FALSE/*Create*/);
	      if ((PROGRAM_ErrorNo == E_NULL) && (pref1 == NULL))
		{
		  diffarray = PreferenceDiffArray_Append(diffarray, NULL, *pp);
		}
	    }
	}
    }
  
  return(PROGRAM_ErrorNo == E_NULL) ? diffarray : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/Preference/RCS/Preference_Diff.c,v $ */

