/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: HintService_GetHint.c,v 1.3 1994/08/12 18:18:46 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Hint.h"
#include "HintService.h"


static HINT *HintService_ReadHintFromLocation();

/*
 * CAVEAT : This is only a temporary function to get hint functionality working
 */
HINT *HintService_GetHint(path, hintlocation)
     char *path;
     char *hintlocation;
{
  HINT *hintp;

  hintp = HintService_ReadHintFromLocation(hintlocation, path);

  return (PROGRAM_ErrorNo == E_NULL) ? hintp : NULL;
}


/*
 * Search hintlocation for hint info for the last subtree on path
 */
static HINT *HintService_ReadHintFromLocation(hintlocation, path)
     char *path;
     char *hintlocation;
{
  FILE *hintfd;
  HINT *hp;
  char hintpath[MAXPATHLEN], hintid[MAXPATHLEN], tmpstr[MAXPATHLEN];
  char lasthintpath[MAXPATHLEN];
  FILESTAT hintlocationstatus;

  Boolean before, during, LocatedHint;
  int Comparison;

  LocatedHint = FALSE; hp = NULL;

  (void)File_GetStatus(hintlocation, &hintlocationstatus, FALSE/*followlinks*/);
  if ((PROGRAM_ErrorNo == E_NULL) && (FILESTAT_Type(&hintlocationstatus)&F_REG))
    {
      hintfd = efopen(hintlocation, "r");
      if (PROGRAM_ErrorNo == E_NULL)
	{
	  before = TRUE; during = FALSE;
	  while (before && (PROGRAM_ErrorNo == E_NULL))
	    {
	      if (fgets(hintpath, MAXPATHLEN, hintfd) == NULL)
		/* eof or error */
		{
		  before = during = FALSE;
		}
	      else if (strncmp(hintpath, "PATH ", 5) != 0)
		{
		  before = during = FALSE;
		  FatalError(E_BADHINTS,
			     "Corrupted hints in location %s\n", hintlocation);
		}
	      else
		{
		  Comparison = strncmp(hintpath+5, path, strlen(hintpath+5)-1);
		  if (Comparison == 0)
		    {
		      before = FALSE; during = TRUE;
		      LocatedHint = TRUE;
		    }
		  else if (Comparison > 0)
		    {
		      before = during = FALSE;
		    }
		  else /* Comparison < 0 */
		    {
		      if ((fgets(hintid, MAXPATHLEN, hintfd) == NULL)
			  || (fgets(tmpstr, MAXPATHLEN, hintfd) == NULL))
			{
			  before = during = FALSE;
			  FatalError(E_BADHINTS,
				     "Unexpected end to hints in location %s\n",
				     hintlocation);
			}
		      else if ((strncmp(hintid, "ID ", 3) != 0)
			       || (strncmp(tmpstr, "MODTIME ", 8) != 0))
			{
			  before = during = FALSE;
			  FatalError(E_BADHINTS,
				     "Corrupted hints in location %s\n",
				     hintlocation);
			}
		    }
		}
	    }

	  if (LocatedHint && (PROGRAM_ErrorNo == E_NULL))
	    hp = (HINT *)emalloc(sizeof(HINT));

	  while (during && (PROGRAM_ErrorNo == E_NULL))
	    {
	      if ((fgets(hintid, MAXPATHLEN, hintfd) == NULL)
		  || (fgets(tmpstr, MAXPATHLEN, hintfd) == NULL))
		{
		  before = during = FALSE;
		  FatalError(E_BADHINTS,
			     "Unexpected end to hints in location %s\n",
			     hintlocation);
		}
	      else if ((strncmp(hintid, "ID ", 3) != 0)
		       || (strncmp(tmpstr, "MODTIME ", 8) != 0))
		{
		  before = during = FALSE;
		  FatalError(E_BADHINTS,
			     "Corrupted hints in location %s\n", hintlocation);
		}
	      else if (Comparison == 0)
		{
		  (void)strcpy(lasthintpath, hintpath);
		  if (lasthintpath[strlen(lasthintpath)-1] == '\n')
		    lasthintpath[strlen(lasthintpath)-1] = '\0';
		  if (hintid[strlen(hintid)-1] == '\n')
		    hintid[strlen(hintid)-1] = '\0';
		  if (tmpstr[strlen(tmpstr)-1] == '\n')
		    tmpstr[strlen(tmpstr)-1] = '\0';
		  HINT_PathName(hp) = String(lasthintpath + 5,/*offset "PATH "*/
					     strlen(lasthintpath + 5));
		  HINT_UniqueID(hp) = String(hintid + 3, /* offset "ID " */
					     strlen(hintid + 3));
		  HINT_ModTime(hp) = (time_t)atoi(tmpstr+8);
		  /* number at offset "MODTIME " */
		}

	      if (PROGRAM_ErrorNo == E_NULL)
		{
		  if (fgets(hintpath, MAXPATHLEN, hintfd) == NULL)
		    /* eof or error */
		    {
		      before = during = FALSE;
		    }
		  else if (strncmp(hintpath, "PATH ", 5) != 0)
		    {
		      before = during = FALSE;
		      FatalError(E_BADHINTS,
				 "Corrupted hints in location %s\n",
				 hintlocation);
		    }
		  else
		    {
		      Comparison = strncmp(hintpath + 5,
					   path,
					   strlen(hintpath + 5) - 1);
		      if (Comparison > 0)
			{
			  before = during = FALSE;
			}
		    }
		}
	    }

	  fclose(hintfd);
	}
    }

  return (LocatedHint && (PROGRAM_ErrorNo == E_NULL)) ? hp : NULL;
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/HintService/RCS/HintService_GetHint.c,v $ */
