/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: Hint_CollectPathHints.c,v 1.4 1994/08/12 18:03:19 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Hint.h"


HINTDB Hint_CollectPathHints(fsimage, pathlist)
     FILESYSTEMIMAGE *fsimage;
     char **pathlist;
{
  register char **cp;
  register FILESYSTEMIMAGE *fsp;
  Boolean HintFound;
  HINT hint;
  char hintpath[MAXPATHLEN], id[MAXPATHLEN];
  char *expectednodename;
  HINTDB hintinfo;

  hintinfo = NULL;

  if (pathlist != NULL)
    {
      HINT_PathName(&hint) = hintpath;
      HINT_UniqueID(&hint) = id;

      /* iterate to collect hints */
      for (cp = pathlist; *cp != NULL; cp++)
	{
	  HintFound = FALSE; fsp = fsimage;
	  hintpath[0] = '\0'; id[0] = '\0';
	  while (!HintFound && (fsp != NULL))
	    {
	      if (hintpath[0] == '\0')
		expectednodename = *cp;
	      else
		expectednodename = *cp+strlen(hintpath)+1;
	      if (strncmp(expectednodename,
			  FILESYSTEMIMAGE_Name(fsp),
			  strlen(FILESYSTEMIMAGE_Name(fsp))) == 0)
		{
		  if ((FILESYSTEMIMAGE_Type(fsp) & FS_DIR)
		      && (FILESYSTEMIMAGE_Type(fsp) & FS_FSMOUNT)
		      && (FILESYSTEMIMAGE_FSMountID(fsp) != NULL))
		    (void)strcpy(id, FILESYSTEMIMAGE_FSMountID(fsp));
		  HINT_ModTime(&hint) = FILESYSTEMIMAGE_DTime(fsp);
		  if (hintpath[0] == '\0')
		    (void)strcpy(hintpath, FILESYSTEMIMAGE_Name(fsp));
		  else if ((strcmp(FILESYSTEMIMAGE_Name(fsp), "/") == 0)
			   || (strcmp(FILESYSTEMIMAGE_Name(fsp), ".") == 0))
		    /* do nothing, hintpath remains as is */ ;
		  else
		    (void)sprintf(hintpath, "%s/%s", hintpath,
				  FILESYSTEMIMAGE_Name(fsp));
		  if (strcmp(hintpath, *cp) == 0)
		    HintFound = TRUE;
		  else
		    fsp = FILESYSTEMIMAGE_Child(fsp);
		}
	      else
		fsp = FILESYSTEMIMAGE_Next(fsp);
	    }
	  if (HintFound)
	    hintinfo = HintDB_InsertHint(hintinfo, &hint, FALSE/*!OverWrite*/);
	}
    }
  return (PROGRAM_ErrorNo == E_NULL) ? hintinfo : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/Hint/RCS/Hint_CollectPathHints.c,v $ */
