/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: HintDB_UnsetPathPrefix.c,v 1.4 1995/05/10 21:54:27 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Hint.h"

/*
 * HINTDB HintDB_UnsetPathPrefix(hintdb, pathprefix)
 *      HINTDB hintdb;
 *      char *pathprefix;
 * removes the specified prefix from each path in the hint database hintdb.
 * It then returns the updated hint database, or NULL if an error occurs.
 * All paths in the database must have the specified prefix or an error occurs.
 */
HINTDB 
HintDB_UnsetPathPrefix(hintdb, pathprefix)
     HINTDB hintdb;
     char *pathprefix;
{
  HINTDB newdb;
  char *newpath;
  int prefixlen;

  register HINTDB hp;

  newdb = hintdb;
  if ((newdb != NULL) && (pathprefix != NULL) && (pathprefix[0] != '\0')) {
    prefixlen = (int) strlen(pathprefix);
    for (hp = newdb;
	 (PROGRAM_ErrorNo == E_NULL) && (*hp != NULL);
	 hp++) {
      if (*hp != NULL) {
	if (strncmp(HINT_PathName(*hp), pathprefix, prefixlen) != 0) {
	  FatalError(E_BADHINTPATHPREFIX,
		     "Hint without specified prefix %s in database\n",
		     pathprefix);
	} else {
	  if (*(HINT_PathName(*hp) + prefixlen) == '\0')
	    /* (strcmp(HINT_PathName(*hp), pathprefix) == 0) */
	  {
	    newpath = (char *) emalloc(2);
	    if (PROGRAM_ErrorNo == E_NULL)
	      (void) strcpy(newpath, "/");
	  } else if (*(HINT_PathName(*hp) + prefixlen) == '/') {
	    newpath = (char *) emalloc(strlen(HINT_PathName(*hp))
				       - prefixlen);
	    if (PROGRAM_ErrorNo == E_NULL)
	      (void) strcpy(newpath, HINT_PathName(*hp) + prefixlen + 1);
	  }
	  /* else this is not a hint for this subtree */
	  if (PROGRAM_ErrorNo == E_NULL) {
	    (void) free((void *) HINT_PathName(*hp));
	    HINT_PathName(*hp) = newpath;
	  }
	}
      }
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newdb : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/020/src/lib/Hint/RCS/HintDB_UnsetPathPrefix.c,v $ */
