/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: HintDB_MergeHintDB.c,v 1.3 1994/08/12 18:00:51 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Hint.h"

/*
 * HINTDB HintDB_MergeHintDB(hintdb, deltadb, OverWrite)
 *	HINTDB hintdb, deltadb;
 *	Boolean OverWrite;
 * merges the hint information in the new hint database deltadb
 * the NULL terminated array of hints hintdb, sorted by the pathname field.
 * The OverWrite flag determines whether already existing hints are overwritten.
 * It then returns the updated array of hints, or NULL if an error occurs.
 */
HINTDB HintDB_MergeHintDB(hintdb, deltadb, OverWrite)
     HINTDB hintdb, deltadb;
     Boolean OverWrite;
{
  register HINTDB hp;

  HINTDB newdb;

  if (deltadb == NULL)
    {
      FatalError(E_NULLHINTDB,
		 "Attempt to merge NULL hint database into array of hints\n");
    }

  newdb = hintdb;
  if (newdb == NULL)
    { /* allocate array of length 1 */
      newdb = (HINTDB )emalloc(sizeof(HINT *));
      if (PROGRAM_ErrorNo == E_NULL) *newdb = NULL;
    }

  for (hp = deltadb;
       (PROGRAM_ErrorNo == E_NULL) && (*hp != NULL);
       hp++)
    {
      newdb = HintDB_InsertHint(newdb, *hp, OverWrite);
    }

  return (PROGRAM_ErrorNo == E_NULL) ? newdb : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/Hint/RCS/HintDB_MergeHintDB.c,v $ */
