/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#ifndef _DEPOT_FILESYSTEMIMAGE_H
#define _DEPOT_FILESYSTEMIMAGE_H

/* $Id: FileSystemImage.h,v 1.4 1994/08/12 14:24:31 ww0r Exp $
 *
 * Author: Chris Newman
 *         Modified by Sohan C. Ramakrishna Pillai for depot
 *
 */

/* Information structure for a pre-scanned directory tree */
typedef struct treenode {
    int type;			/* type of node */
    mode_t mode;		/* only low 9 bits are significant */
    uid_t uid;                  /* user id & group id */
    gid_t gid;	
    size_t size;		/* size of file */
    time_t mtime;	        /* last modification time */
    time_t dtime;	        /* last modification of subtree */
    unsigned long count;	/* number of entries in dir */
    char *name;			/* name of file */
    char *link;			/* value of link or mount point */
    struct treenode *next;	/* next entry */
    struct treenode *child;	/* child of directory */
} treenode, FILESYSTEMIMAGE;


#define FILESYSTEMIMAGE_Type(fp)	((fp)->type)
#define FILESYSTEMIMAGE_Mode(fp)	((fp)->mode)
#define FILESYSTEMIMAGE_Uid(fp)		((fp)->uid)
#define FILESYSTEMIMAGE_Gid(fp)		((fp)->gid)
#define FILESYSTEMIMAGE_Size(fp)	((fp)->size)
#define FILESYSTEMIMAGE_MTime(fp)	((fp)->mtime)
#define FILESYSTEMIMAGE_DTime(fp)	((fp)->dtime)
#define FILESYSTEMIMAGE_Count(fp)	((fp)->count)
#define FILESYSTEMIMAGE_Name(fp)	((fp)->name)
#define FILESYSTEMIMAGE_Link(fp)	((fp)->link)
#define FILESYSTEMIMAGE_FSMountID(fp)	((fp)->link)
#define FILESYSTEMIMAGE_Child(fp)	((fp)->child)
#define FILESYSTEMIMAGE_Next(fp)	((fp)->next)

/*
 * both FILESYSTEMIMAGE_Link(fp) FILESYSTEMIMAGE_FSMountID(fp)
 * evaluate to ((fp)->link). We reuse that space because file
 * system mount points will not need use of the link field.
 */

/* FILESYSTEMIMAGE types */
#define FS_NUL      0x000
#define FS_REG      0x001
#define FS_SYMLNK   0x002
#define FS_HARDLNK  0x004
#define FS_DIR      0x008
#define FS_FSMOUNT  0x010
#define FS_OTHER    0x020


/* FILESYSTEMIMAGE info identifiers */
#define FSINFO_MODE    'M'
#define FSINFO_SIZE    'S'
#define FSINFO_MODTIME 'T'
#define FSINFO_DIRTIME 't'
#define FSINFO_COUNT   'C'
#define FSINFO_LINK    'L'
#define FSINFO_FSMT    'F'
#define FSINFO_UID     'U'
#define FSINFO_GID     'G'

#define FILESYSTEMIMAGE_magic "#treeinfo"

/* treeinfo utility routines */
extern void FileSystemImage_Write( /* FILE *out, FILESYSTEMIMAGE *root */ );
extern FILESYSTEMIMAGE *FileSystemImage_Read( /* char *filename */ );
extern FILESYSTEMIMAGE *FileSystemImage_Build( /* char *filename */ );
extern FILESYSTEMIMAGE *FileSystemImage_LocateNode(/* FILESYSTEMIMAGE *fsimagep,
						      char *pathtonode */ );

extern void FileSystemImage_Free();

#endif /* _DEPOT_FILESYSTEMIMAGE_H */
/* $Source: /afs/andrew/system/src/local/depot2/013/src/lib/FileSystemImage/RCS/FileSystemImage.h,v $ */
