/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#if !defined(SABER) && !defined(LINT)
static char rcs_id[]="$Id: File_Move.c,v 1.11 1996/04/15 17:33:55 wcw Exp $";
#endif /* SABER && LINT */


/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "busy.h"

static int
move_busy(name1, name2) 
  char *name1, *name2;
{
  char *busyname;

  busyname = _genbusy_name(name2);
  if (PROGRAM_ErrorNo != E_NULL)
    return -1;

  if (busyname == NULL) {
    Filtered_Message(PROGRAM_Verbose, "...Busy file... already renamed.\n");
    return 0;
  }

  Filtered_Message(PROGRAM_Verbose, 
		   "...Busy file detected...MOVE %s %s", name2, busyname);
  if (rename(name2, busyname) < 0) 
    return -1;
	
  Filtered_Message(PROGRAM_Verbose, 
		   "...MOVE %s %s", name1, name2);
  if (rename(name1, name2) < 0)
    return -1;

  return 0;

}
  

int 
File_Move(name1, name2)
  char *name1, *name2;
{
  Filtered_Message(PROGRAM_Verbose, "MOVE %s %s", name1, name2);

  if (rename(name1, name2) < 0) {
    if (errno == ETXTBSY) {
      if (move_busy(name1, name2) < 0) 
	goto error;
    } else if ((errno == EISDIR)      /* possible rename to a directory errno's */
	       || (errno == ENOTEMPTY)
	       || (errno == EEXIST)) {
      Filtered_Message(PROGRAM_Verbose, "...%s is a directory...", name2);
      if (File_RemovePath(name2, NULL) < 0) {
	goto error;
      }
      if (rename(name1, name2) < 0) {
	goto error;
      }
    } else {
      error:
      {
	FatalError(E_RENAMEFAILED,
		   "\nCould not rename %s to %s: %s\n",
		   name1, name2, strerror(errno));
      }
    }
  }
  Filtered_Message(PROGRAM_Verbose, "\n", name1, name2);
  return ((PROGRAM_ErrorNo == E_NULL) ? 0 : -1);
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/022/src/lib/FileOps/RCS/File_Move.c,v $ */

