/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: File_GetStatus.c,v 1.5 1994/08/12 14:11:06 ww0r Exp ww0r $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */


#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"

#ifdef LOG_STAT
static void
log_stat(path)
  char *path;
{
  static FILE *fp = NULL;

  if (fp == NULL) {
    char filename[MAXPATHLEN+1];
    sprintf(filename, "/tmp/stat-log.%d", getpid());
    if ((fp = fopen(filename, "w")) == NULL) {
      perror("fopen in log_stat");
      exit(-1);
    }
  }
  (void)fputs(path, fp);
  (void)fputc('\n', fp);
  (void)fflush(fp);
  /* NOTE: we don't ever close the file... this is to cut down on overhead 
   * of continually opening and closing it 
   */
}
#endif

int 
File_GetStatus(path, status, followlinks)
     char *path;
     FILESTAT *status;
     Boolean followlinks;
{
  int rval;
  struct stat stb;

  if (followlinks) {
    rval = stat(path, &stb);
  } else {
    rval = lstat(path, &stb);
  }

#ifdef LOG_STAT
  log_stat(path);
#endif

  if (rval < 0) {
    if (errno == ENOENT) {
      FILESTAT_Type(status) = F_NUL;
      errno = 0;
      return 0;
    } else {
      FatalError(E_STATFAILED,
		 "Could not stat %s: %s\n", path, strerror(errno));
    }
    return -1;
  } 
  if (S_ISREG(stb.st_mode))
    FILESTAT_Type(status) = F_REG;
  else if ((stb.st_mode & S_IFMT) == S_IFLNK)
    FILESTAT_Type(status) = F_LNK;
  else if (S_ISDIR(stb.st_mode)) {
    FILESTAT_Type(status) = F_DIR;
  } else { /* (!(stb.st_mode & (S_IFDIR | S_IFREG | S_IFLNK))) */
    FatalError(E_GETSTATUSFAILED,
	       " %s is not a file or directory\n", path);
    return -1;
  }

  FILESTAT_Mode(status) = (stb.st_mode & 07777);
  FILESTAT_NLinks(status) = stb.st_nlink;
  FILESTAT_Uid(status) = stb.st_uid;
  FILESTAT_Gid(status) = stb.st_gid;
  FILESTAT_Size(status) = stb.st_size;
  FILESTAT_MTime(status) = stb.st_mtime;
  FILESTAT_INode(status) = stb.st_ino;

  return 0;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/012/src/lib/FileOps/RCS/File_GetStatus.c,v $ */
 
