/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: DepotDB_TargetDB_Read.c,v 1.6 1994/10/11 20:21:43 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Preference.h"
#include "DepotConf.h"
#include "Hint.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"
#include "DepotDB.h"



TARGETDB *
DepotDB_TargetDB_Read(dbh)
     DEPOTDBHANDLE *dbh;
{
  TARGETDB *tdb;
  char buf[10];			/* make sure this is big enough for the magic number */
  Boolean Compress = TRUE;

  /* seek past magic number and trailing \n */
  if (fseek(DEPOTDBHANDLE_FP(dbh),
	    DEPOTDBHANDLE_OFF_TARGET(dbh) + strlen(TARGETDBVERSIONSTRING) +1, 
	    SEEK_SET) < 0) {
    FatalError(E_FSEEKFAILED,
	       "Failed to fseek target database in depotdatabase file.\n");
  }

  /* check to see if the targetdb file is compressed or not */ 
  if (fgets(buf, sizeof(buf), DEPOTDBHANDLE_FP(dbh)) == NULL) {
    FatalError(E_TARGETDBVERSION, "Unable to read targetdb magic number: %s\n", 
	       strerror(errno));
  }
  if (strncmp(buf, TARGETDB_COMPRESS_MAGIC, strlen(TARGETDB_COMPRESS_MAGIC)) == 0) {
    Compress = TRUE;
  } else {
    Compress = FALSE;
  }
  /* reset back to where things should be */
  if (fseek(DEPOTDBHANDLE_FP(dbh),
	    DEPOTDBHANDLE_OFF_TARGET(dbh),
	    SEEK_SET) < 0) {
    FatalError(E_FSEEKFAILED,
	       "Failed to fseek target database in depotdatabase file.\n");
  }

  if (PROGRAM_ErrorNo == E_NULL)
    tdb = TargetDB_Read(DEPOTDBHANDLE_FP(dbh), Compress);

  return (PROGRAM_ErrorNo == E_NULL) ? tdb : NULL;
}

/* $Source: /afs/andrew/system/src/local/depot2/014/src/lib/DepotDB/RCS/DepotDB_TargetDB_Read.c,v $ */
