/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: GlobalDepotConf_ExtractCollectionDepotConf.c,v 1.4 1994/08/12 13:52:42 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
   * Author: Sohan C. Ramakrishna Pillai
    */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "DepotConf.h"


DEPOTCONFDB *GlobalDepotConf_ExtractCollectionDepotConf(confdbp,
							  collection_name)
     DEPOTCONFDB *confdbp;
     char *collection_name;
{
  register DEPOTCONF **dp, **cdp;
  DEPOTCONFDB *collectionconfdbp;
  int collectionconfdbpsize;

  if (confdbp == NULL)
    {
      FatalError(E_BADDEPOTCONFDB,
		 "Attempt to extract info from NULL depot.conf database\n");
    }
  else if (*confdbp == NULL)
    /* EMPTY */
    {
      collectionconfdbp = NULL;
    }
  else
    {
      collectionconfdbp = NULL; dp = *confdbp;
      while ((*dp != NULL) && (PROGRAM_ErrorNo == E_NULL))
	{
	  if ((String_Comparator(DEPOTCONF_CollectionName(*dp),
				 collection_name) == 0)
	      || (String_Comparator(DEPOTCONF_CollectionName(*dp),
				    DEPOTCONF_WILDITEM) == 0)
	      || (String_Comparator(collection_name,
				    DEPOTCONF_WILDITEM) == 0))
	    {
	      if (collectionconfdbp == NULL)
		{ /* allocate array of length 1 */
		  collectionconfdbp
		    = (DEPOTCONFDB *)emalloc(sizeof(DEPOTCONFDB));
		  if (PROGRAM_ErrorNo == E_NULL)
		    *collectionconfdbp
		      = (DEPOTCONFDB)emalloc(sizeof(DEPOTCONF *));
		  if (PROGRAM_ErrorNo == E_NULL)
		    **collectionconfdbp = NULL;
		}

	      if (PROGRAM_ErrorNo == E_NULL)
		{
		  collectionconfdbpsize = DepotConfDB_Size(collectionconfdbp)+1;
		  collectionconfdbpsize++;
		  *collectionconfdbp
		    = (DEPOTCONFDB)erealloc((void *)*collectionconfdbp,
					    (unsigned)collectionconfdbpsize
					    *sizeof(DEPOTCONF *));
		}

	      if (PROGRAM_ErrorNo == E_NULL)
		{
		  cdp = *collectionconfdbp + collectionconfdbpsize - 2;
		  *cdp = (DEPOTCONF *)emalloc(sizeof(DEPOTCONF));
		  if (*cdp != NULL)
		    {
		      DEPOTCONF_CollectionName(*cdp)
			= String(DEPOTCONF_CollectionName(*dp),
				 strlen(DEPOTCONF_CollectionName(*dp)));
		      DEPOTCONF_Spec(*cdp) = DEPOTCONF_Spec(*dp);
		      DEPOTCONF_ConfValue(*cdp)
			=StringArray(DEPOTCONF_ConfValue(*dp),
				     StringArray_Size(DEPOTCONF_ConfValue(*dp)));
		    }
		  *(cdp+1) = NULL;
		}
	    }
	  dp++;
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? collectionconfdbp : NULL;
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/DepotConf/RCS/GlobalDepotConf_ExtractCollectionDepotConf.c,v $ */


