/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: CollectionDepotConf_Write.c,v 1.4 1994/08/12 13:46:07 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "DepotConf.h"

static char CollectionDepotConfSpecialChars[] =
{
  ' ', '\t', '\n',  '\'', '\"', '\\',
  '\0'
};

static int NCollectionDepotConfSpecialChars =
  sizeof(CollectionDepotConfSpecialChars)/
  sizeof(CollectionDepotConfSpecialChars[0]) - 1;

int CollectionDepotConfDB_Write(fd, confdbp)
     FILE *fd;
     DEPOTCONFDB *confdbp;
{
  register DEPOTCONF **dp;

  if (confdbp == NULL)
    {
      FatalError(E_BADDEPOTCONFDB,
		 "Attempt to write NULL depot.conf database\n");
    }
  else if (*confdbp == NULL)
    /* EMPTY */
    {
      /* do nothing */;
    }
  else
    {
      dp = *confdbp;
      while ((*dp != NULL) && (PROGRAM_ErrorNo == E_NULL))
	{
	  switch(DEPOTCONF_Spec(*dp))
	    {
	    case DC_MAP:
	      break;
	    case DC_DELETE:
	      fputs("~delete ", fd);
	      break;
	    case DC_COMMAND:
	      fputs("~command ", fd);
	      break;
	    default:
	      FatalError(E_BADDEPOTCONFSPEC,
			 "Attempt to write bad depot.conf specification\n");
	      break;
	    }
	  if (PROGRAM_ErrorNo == E_NULL)
	    {
	      StringArray_Write(fd, DEPOTCONF_ConfValue(*dp),
				'\\', ' ',
				CollectionDepotConfSpecialChars,
				NCollectionDepotConfSpecialChars);
	      putc('\n', fd);
	    }
	  dp++;
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/DepotConf/RCS/CollectionDepotConf_Write.c,v $ */
