/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


%{
#define YYDEBUG 1

#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: CollectionDepotConf_Read.y,v 1.5 1994/08/12 13:45:49 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "DepotConf.h"

DEPOTCONFDB *yyDB;
char *yyCollectionName;
extern int yylineno;
extern char *yytext;
extern int yyleng;
extern int yydebug;
extern int debug;
#define dbgprintf(x) /*fprintf x */

%}

%union
{
  int	ival;
  unsigned unsval;
  Boolean boolval;
  char	chrval;
  char *strval;
  STRINGARRAY *strarrval;
}

%token <strval> SOURCE
%token <strval> TARGET
%token <strval> COMMANDLABEL
%token <intval> MAPPING
%token <intval> DELETE
%token <intval> COMMAND
%token <intval> UNKSPEC
%token <strval> STRING
%token <ival> COMMENT
%token <ival> NEWLINE

%type <ival> input
%type <ival> entry
%type <ival> Specification
%type <strarrval> TargetList

%start input

%%	 /* rules */


input    : /* Empty */
           { $$ = 0; }
         | input line
           { $$ = $1; }
         ;

line     : NEWLINE
         | entry NEWLINE
         | entry
         ;

entry	:       COMMENT
			{
			  dbgprintf((stdout, "COMMENT\n"));
			  $$ = 0;
			}
	|	Specification
			{
			  dbgprintf((stdout, "Specification\n"));
			  $$ = $1;
			}
	;

Specification:	SOURCE
			{
			  dbgprintf((stdout, "MAPPING %s\n", $1));
			  yyDB =
			    DepotConfDB_Map(yyDB, yyCollectionName, $1, $1);
			  String_Free($1);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	|	SOURCE TARGET
			{
			  dbgprintf((stdout, "MAPPING %s %s \n", $1, $2));
			  yyDB =
			    DepotConfDB_Map(yyDB, yyCollectionName, $1, $2);
			  String_Free($1); String_Free($2);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	|	MAPPING SOURCE
			{
			  dbgprintf((stdout, "MAPPING SOURCE %s\n", $2));
			  yyDB =
			    DepotConfDB_Map(yyDB, yyCollectionName, $2, $2);
			  String_Free($2);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	|	MAPPING SOURCE TARGET
			{
			  dbgprintf((stdout, "MAPPING SOURCE %s TARGET %s\n",
				    $2,$3));
			  yyDB =
			    DepotConfDB_Map(yyDB, yyCollectionName, $2, $3);
			  String_Free($2); String_Free($3);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	|	DELETE TARGET
			{
			  dbgprintf((stdout, "DELETE\n"));
			  yyDB =
			    DepotConfDB_Delete(yyDB, yyCollectionName, $2);
			  String_Free($2);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	|	COMMAND COMMANDLABEL TargetList
			{
			  dbgprintf((stdout, "Command\n"));
			  yyDB =
			    DepotConfDB_Command(yyDB, yyCollectionName, $2, $3);
			  String_Free($2); StringArray_Free($3);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


TargetList:	/* empty */
			{
			  dbgprintf((stdout, "NULL TARGET\n"));
			  $$ = NULL;
			}
	|	TargetList TARGET
			{
			  dbgprintf((stdout, "TARGET\n"));
			  $$ = StringArray_AppendString($1, $2);
			  String_Free($2);
			}
	;


%%

yyerror(str)
     char *str;
{
  FatalError(E_COLLDEPOTCONFPARSE,
	     "depot.conf error in %s: %s: line %d\n", 
	     yyCollectionName, str, yylineno);
}


yywrap()
{ 
  return 1; 
}


DEPOTCONFDB *CollectionDepotConfDB_Read(fp, collectionname)
     FILE *fp;
     char *collectionname;
{
  extern FILE *yyin;

  if (collectionname == NULL)
    {
      FatalError(E_NULLCOLLECTIONNAME,
		 "Attempt to read depotconf database for NULL collection.\n");
    }
  yylineno = 1;
  yyclearin;
  yyparseinit();
  if (PROGRAM_ErrorNo == E_NULL)
    yyDB = (DEPOTCONFDB *)emalloc(sizeof(DEPOTCONFDB));
  if (PROGRAM_ErrorNo == E_NULL)
    *yyDB = NULL;

  yyin = fp; yyCollectionName = collectionname;
  if ((PROGRAM_ErrorNo == E_NULL) && (yyparse() < 0))
    {
      FatalError(E_COLLDEPOTCONFPARSE,
		 "Error parsing depot.conf file for collection %s\n",
		 yyCollectionName);
    }

  return (PROGRAM_ErrorNo == E_NULL) ? yyDB : NULL;
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/DepotConf/RCS/CollectionDepotConf_Read.y,v $ */
