/***********************************************************
        Copyright 1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#if !(defined(SABER) || defined(LINT))
static char rcs_id[]="$Id: CollectionList_LocateCollection.c,v 1.3 1994/08/12 03:28:48 ww0r Exp $";
#endif /* SABER || LINT */

/*
 * Author: Walter C. Wong
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "Hint.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"

COLLECTION *
CollectionList_LocateCollectionByName(name, clist)
  char *name;
  COLLECTIONLIST *clist;
{
  static COLLECTION ret;
  register COLLECTION *cp;
  register int i;

  if (clist == NULL) {
    return NULL;
  }
  (void)memcpy(&ret, 0, sizeof(COLLECTION));
  
  for (i = 0; i<COLLECTIONLIST_Size(clist); i++) {
    cp = COLLECTIONLIST_Collection(clist, i);
    if (cp != NULL) {
      if (strcmp(name, COLLECTION_Name(cp)) == 0) {
	(void)memcpy(&ret, cp, sizeof(COLLECTION));
	return &ret;
      }
    }
  }
  return NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/CollectionList/RCS/CollectionList_LocateCollection.c,v $ */
