/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: Collection_TargetDB.c,v 1.6 1994/10/31 14:41:49 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Hint.h"
#include "File.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"


TARGETDB *
Collection_TargetDBCreateNonVirginPath(targetdbp,
				       source, target,
				       collectionp)
     TARGETDB *targetdbp;
     char *source, *target;
     COLLECTION *collectionp;
{
  register char **sp;

  TARGETDB *newtargetdbp;
  TARGETDB *childnodep;
  TARGETSOURCE *thissource;
  char **targetpatharray;
  STRINGSET *targetpathstringarray;

  if (target == NULL) {
    FatalError(E_BADTARGET,
	       "Attempt to create non-virgin path to NULL target in collection: %s\n",
	       COLLECTION_Name(collectionp));
  }
  /* create source structure to add to path in newtargetdb */
  thissource = TargetSource_Create(source,
				   U_MKDIR | U_NONVIRGIN,
				   COLLECTION_Id(collectionp),
				   S_NULL,
				   U_NULL /* update_spec_old */ ,
				   NULL);

  newtargetdbp = targetdbp;

  /* create rootnode for newtargetdbp if necessary */
  if (newtargetdbp == NULL) {
    newtargetdbp = TargetDB_Create("/" /* name of root node */ ,
				   U_NULL /* update_spec */ ,
				   NULL /* target file status */ ,
				   S_NULL /* status */ ,
				   NULL /* sourcelist */ ,
				   U_NULL /* update_spec_old */ ,
				   NULL /* old target file status */ ,
				   0, NULL /* childcount, children */ );
  }
  /* create new source at root node for newtargetdbp */
  TARGETDB_SourceList(newtargetdbp) =
    Collection_SourceList_AddSource(TARGETDB_SourceList(newtargetdbp),
				    thissource,
				    collectionp);

  /* split target path into array of its components */
  if (PROGRAM_ErrorNo == E_NULL) {
    targetpathstringarray = StringToStringArray(target,
						'/' /* delimited by /s */ ,
						-1 /* no quotechar */ );
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    if (targetpathstringarray == NULL) {
      targetpatharray = NULL;
    } else {
      targetpatharray = STRINGARRAY_Values(targetpathstringarray);
    }
  }
  if (targetpatharray != NULL) {
    for (sp = targetpatharray, childnodep = newtargetdbp;
	 (PROGRAM_ErrorNo == E_NULL) && (*sp != NULL);
	 sp++) {
      /* create new child node if necessary */
      childnodep = TargetDB_LocateChildNode(childnodep,
					    *sp,
					    TDB_LOCATE | TDB_CREATE);
      /* add source to all but non-leaf nodes */
      if (PROGRAM_ErrorNo == E_NULL) {
	if (*(sp + 1) != NULL) {
	  TARGETDB_SourceList(childnodep) =
	    Collection_SourceList_AddSource
	    (TARGETDB_SourceList(childnodep),
	     thissource,
	     collectionp);
	}
      }
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    TargetSource_Free(thissource);
    if (targetpathstringarray != NULL)
      (void) StringArray_Free(targetpathstringarray);
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}



TARGETDB *
Collection_TargetDBCreateCommandPath(targetdbp,
				     source, target,
				     collectionp)
     TARGETDB *targetdbp;
     char *source, *target;
     COLLECTION *collectionp;
{
  register char **sp;

  TARGETDB *newtargetdbp;
  TARGETDB *childnodep;
  TARGETSOURCE *thissource;
  char **targetpatharray;
  STRINGSET *targetpathstringarray;

  if (target == NULL) {
    FatalError(E_BADTARGET,
	       "Attempt to create command path to NULL target in collection: %s\n",
	       COLLECTION_Name(collectionp));
  }
  /* create source structure to add to path in newtargetdb */
  thissource = TargetSource_Create(source,
				   U_MKDIR | U_NONVIRGIN | U_COMMANDPATH,
				   COLLECTION_Id(collectionp),
				   S_NULL,
				   U_NULL /* update_spec_old */ ,
				   NULL);

  newtargetdbp = targetdbp;

  /* create rootnode for newtargetdbp if necessary */
  if (newtargetdbp == NULL) {
    newtargetdbp = TargetDB_Create("/" /* name of root node */ ,
				   U_NULL /* update_spec */ ,
				   NULL /* target file status */ ,
				   S_NULL /* status */ ,
				   NULL /* sourcelist */ ,
				   U_NULL /* update_spec_old */ ,
				   NULL /* old target file status */ ,
				   0, NULL /* childcount, children */ );
  }
  /* create new source at root node for newtargetdbp */
  TARGETDB_SourceList(newtargetdbp) =
    Collection_SourceList_AddSource(TARGETDB_SourceList(newtargetdbp),
				    thissource,
				    collectionp);

  /* split target path into array of its components */
  if (PROGRAM_ErrorNo == E_NULL) {
    targetpathstringarray = StringToStringArray(target,
						'/' /* delimited by /s */ ,
						-1 /* no quotechar */ );
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    if (targetpathstringarray == NULL) {
      targetpatharray = NULL;
    } else {
      targetpatharray = STRINGARRAY_Values(targetpathstringarray);
    }
  }
  if (targetpatharray != NULL) {
    for (sp = targetpatharray, childnodep = newtargetdbp;
	 (PROGRAM_ErrorNo == E_NULL) && (*sp != NULL);
	 sp++) {
      /* create new child node if necessary */
      childnodep = TargetDB_LocateChildNode(childnodep,
					    *sp,
					    TDB_LOCATE | TDB_CREATE);
      /* add source to all but non-leaf nodes */
      if (PROGRAM_ErrorNo == E_NULL) {
	if (*(sp + 1) != NULL) {
	  TARGETDB_SourceList(childnodep) =
	    Collection_SourceList_AddSource
	    (TARGETDB_SourceList(childnodep),
	     thissource,
	     collectionp);
	}
      }
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    TargetSource_Free(thissource);
    if (targetpathstringarray != NULL)
      (void) StringArray_Free(targetpathstringarray);
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/Collection/RCS/Collection_TargetDB.c,v $ */
